/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.registry.zookeeper.service;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.WatchPathable;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.eventmesh.api.exception.RegistryException;
import org.apache.eventmesh.api.registry.RegistryService;
import org.apache.eventmesh.api.registry.dto.EventMeshDataInfo;
import org.apache.eventmesh.api.registry.dto.EventMeshRegisterInfo;
import org.apache.eventmesh.api.registry.dto.EventMeshUnRegisterInfo;
import org.apache.eventmesh.common.config.CommonConfiguration;
import org.apache.eventmesh.common.utils.ConfigurationContextUtil;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.registry.zookeeper.pojo.EventMeshInstance;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperRegistryService
implements RegistryService {
    private static final Logger log = LoggerFactory.getLogger(ZookeeperRegistryService.class);
    private final AtomicBoolean initStatus = new AtomicBoolean(false);
    private final AtomicBoolean startStatus = new AtomicBoolean(false);
    private String serverAddr;
    public CuratorFramework zkClient;
    private ConcurrentMap<String, EventMeshRegisterInfo> eventMeshRegisterInfoMap;

    public void init() throws RegistryException {
        if (!this.initStatus.compareAndSet(false, true)) {
            log.warn("[ZookeeperRegistryService] has been init");
            return;
        }
        this.eventMeshRegisterInfoMap = new ConcurrentHashMap<String, EventMeshRegisterInfo>(ConfigurationContextUtil.KEYS.size());
        for (String key : ConfigurationContextUtil.KEYS) {
            CommonConfiguration commonConfiguration = ConfigurationContextUtil.get((String)key);
            if (null == commonConfiguration) continue;
            if (StringUtils.isBlank((CharSequence)commonConfiguration.getNamesrvAddr())) {
                throw new RegistryException("namesrvAddr cannot be null");
            }
            this.serverAddr = commonConfiguration.getNamesrvAddr();
            break;
        }
    }

    public void start() throws RegistryException {
        if (!this.startStatus.compareAndSet(false, true)) {
            log.warn("[ZookeeperRegistryService] has been start");
            return;
        }
        try {
            ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(1000, 5);
            this.zkClient = CuratorFrameworkFactory.builder().connectString(this.serverAddr).retryPolicy((RetryPolicy)retryPolicy).namespace("eventmesh").build();
            this.zkClient.start();
        }
        catch (Exception e) {
            throw new RegistryException("ZookeeperRegistry starting failed", (Throwable)e);
        }
    }

    public void shutdown() throws RegistryException {
        if (!this.initStatus.compareAndSet(true, false)) {
            return;
        }
        if (!this.startStatus.compareAndSet(true, false)) {
            return;
        }
        if (null != this.zkClient) {
            this.zkClient.close();
        }
        log.info("ZookeeperRegistryService closed");
    }

    public List<EventMeshDataInfo> findEventMeshInfoByCluster(String clusterName) throws RegistryException {
        ArrayList<EventMeshDataInfo> eventMeshDataInfoList = new ArrayList<EventMeshDataInfo>();
        for (String key : ConfigurationContextUtil.KEYS) {
            CommonConfiguration configuration = ConfigurationContextUtil.get((String)key);
            if (Objects.isNull(configuration)) continue;
            String eventMeshName = configuration.getEventMeshName();
            try {
                String serviceName = eventMeshName.concat("-").concat(key);
                String servicePath = this.formatServicePath(clusterName, serviceName);
                List instances = (List)this.zkClient.getChildren().forPath(servicePath);
                if (CollectionUtils.isEmpty((Collection)instances)) continue;
                for (String endpoint : instances) {
                    byte[] data;
                    String instancePath = servicePath.concat("/").concat(endpoint);
                    Stat stat = new Stat();
                    try {
                        data = (byte[])((WatchPathable)this.zkClient.getData().storingStatIn(stat)).forPath(instancePath);
                    }
                    catch (Exception e) {
                        log.warn("[ZookeeperRegistryService][findEventMeshInfoByCluster] failed for path: {}", (Object)instancePath, (Object)e);
                        continue;
                    }
                    EventMeshInstance eventMeshInstance = (EventMeshInstance)JsonUtils.parseObject((String)new String(data, StandardCharsets.UTF_8), EventMeshInstance.class);
                    EventMeshDataInfo eventMeshDataInfo = new EventMeshDataInfo(clusterName, serviceName, endpoint, stat.getMtime(), Objects.requireNonNull(eventMeshInstance, "instance must not be Null").getMetaData());
                    eventMeshDataInfoList.add(eventMeshDataInfo);
                }
            }
            catch (Exception e) {
                throw new RegistryException("ZookeeperRegistry findEventMeshInfoByCluster failed", (Throwable)e);
            }
        }
        return eventMeshDataInfoList;
    }

    public List<EventMeshDataInfo> findAllEventMeshInfo() throws RegistryException {
        ArrayList<EventMeshDataInfo> eventMeshDataInfoList = new ArrayList<EventMeshDataInfo>();
        for (Map.Entry entry : this.eventMeshRegisterInfoMap.entrySet()) {
            String serviceName = (String)entry.getKey();
            String clusterName = ((EventMeshRegisterInfo)entry.getValue()).getEventMeshClusterName();
            try {
                String servicePath = this.formatServicePath(clusterName, serviceName);
                List instances = (List)this.zkClient.getChildren().forPath(servicePath);
                if (CollectionUtils.isEmpty((Collection)instances)) continue;
                for (String endpoint : instances) {
                    byte[] data;
                    String instancePath = servicePath.concat("/").concat(endpoint);
                    Stat stat = new Stat();
                    try {
                        data = (byte[])((WatchPathable)this.zkClient.getData().storingStatIn(stat)).forPath(instancePath);
                    }
                    catch (Exception e) {
                        log.warn("[ZookeeperRegistryService][findAllEventMeshInfo] failed for path: {}", (Object)instancePath, (Object)e);
                        continue;
                    }
                    EventMeshInstance eventMeshInstance = (EventMeshInstance)JsonUtils.parseObject((String)new String(data, StandardCharsets.UTF_8), EventMeshInstance.class);
                    EventMeshDataInfo eventMeshDataInfo = new EventMeshDataInfo(clusterName, serviceName, endpoint, stat.getMtime(), Objects.requireNonNull(eventMeshInstance, "instance must not be Null").getMetaData());
                    eventMeshDataInfoList.add(eventMeshDataInfo);
                }
            }
            catch (Exception e) {
                throw new RegistryException("ZookeeperRegistry findAllEventMeshInfo failed", (Throwable)e);
            }
        }
        return eventMeshDataInfoList;
    }

    public void registerMetadata(Map<String, String> metadataMap) {
        for (Map.Entry eventMeshRegisterInfo : this.eventMeshRegisterInfoMap.entrySet()) {
            EventMeshRegisterInfo registerInfo = (EventMeshRegisterInfo)eventMeshRegisterInfo.getValue();
            registerInfo.setMetadata(metadataMap);
            this.register(registerInfo);
        }
    }

    public boolean register(EventMeshRegisterInfo eventMeshRegisterInfo) throws RegistryException {
        try {
            String[] ipPort = eventMeshRegisterInfo.getEndPoint().split(":");
            if (null == ipPort || ipPort.length < 2) {
                return false;
            }
            String ip = ipPort[0];
            int port = Integer.parseInt(ipPort[1]);
            String eventMeshName = eventMeshRegisterInfo.getEventMeshName();
            String eventMeshClusterName = eventMeshRegisterInfo.getEventMeshClusterName();
            Map instanceNumMap = eventMeshRegisterInfo.getEventMeshInstanceNumMap();
            Map metadata = eventMeshRegisterInfo.getMetadata();
            EventMeshInstance eventMeshInstance = new EventMeshInstance();
            eventMeshInstance.setIp(ip);
            eventMeshInstance.setPort(port);
            eventMeshInstance.setInstanceNumMap(instanceNumMap);
            eventMeshInstance.setMetaData(metadata);
            String path = this.formatInstancePath(eventMeshClusterName, eventMeshName, eventMeshRegisterInfo.getEndPoint());
            ((ACLBackgroundPathAndBytesable)this.zkClient.create().orSetData().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(path, Objects.requireNonNull(JsonUtils.toJSONString((Object)eventMeshInstance), "instance must not be Null").getBytes(StandardCharsets.UTF_8));
            this.eventMeshRegisterInfoMap.put(eventMeshName, eventMeshRegisterInfo);
        }
        catch (Exception e) {
            throw new RegistryException("ZookeeperRegistry register failed", (Throwable)e);
        }
        log.info("EventMesh successfully registered to zookeeper");
        return true;
    }

    public boolean unRegister(EventMeshUnRegisterInfo eventMeshUnRegisterInfo) throws RegistryException {
        try {
            String eventMeshName = eventMeshUnRegisterInfo.getEventMeshName();
            String eventMeshClusterName = eventMeshUnRegisterInfo.getEventMeshClusterName();
            String path = this.formatInstancePath(eventMeshClusterName, eventMeshName, eventMeshUnRegisterInfo.getEndPoint());
            this.zkClient.delete().forPath(path);
        }
        catch (Exception e) {
            throw new RegistryException("ZookeeperRegistry unRegister failed", (Throwable)e);
        }
        log.info("EventMesh successfully logout to zookeeper");
        return true;
    }

    private String formatInstancePath(String clusterName, String serviceName, String endPoint) {
        return "/".concat(clusterName).concat("/").concat(serviceName).concat("/").concat(endPoint);
    }

    private String formatServicePath(String clusterName, String serviceName) {
        return "/".concat(clusterName).concat("/").concat(serviceName);
    }

    public String getServerAddr() {
        return this.serverAddr;
    }

    public CuratorFramework getZkClient() {
        return this.zkClient;
    }
}

