/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.metrics.prometheus.metrics;

import io.opentelemetry.api.metrics.GlobalMeterProvider;
import io.opentelemetry.api.metrics.Meter;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.eventmesh.metrics.api.model.Metric;
import org.apache.eventmesh.metrics.api.model.TcpSummaryMetrics;
import org.apache.eventmesh.metrics.prometheus.utils.PrometheusExporterUtils;

public final class PrometheusTcpExporter {
    private static Map<String[], Function<TcpSummaryMetrics, Number>> paramPairs = new HashMap<String[], Function<TcpSummaryMetrics, Number>>(){
        {
            this.put(PrometheusExporterUtils.join("retry.queue.size", "get size of retry queue."), TcpSummaryMetrics::getRetrySize);
            this.put(PrometheusExporterUtils.join("server.tps", "get tps of client to eventMesh."), TcpSummaryMetrics::getClient2eventMeshTPS);
            this.put(PrometheusExporterUtils.join("mq.provider.tps", "get tps of eventMesh to mq."), TcpSummaryMetrics::getEventMesh2mqTPS);
            this.put(PrometheusExporterUtils.join("mq.consumer.tps", "get tps of mq to eventMesh."), TcpSummaryMetrics::getMq2eventMeshTPS);
            this.put(PrometheusExporterUtils.join("client.tps", "get tps of eventMesh to client."), TcpSummaryMetrics::getEventMesh2clientTPS);
            this.put(PrometheusExporterUtils.join("all.tps", "get all TPS."), TcpSummaryMetrics::getAllTPS);
            this.put(PrometheusExporterUtils.join("connection.num", "EventMeshTcpConnectionHandler.connections."), TcpSummaryMetrics::getAllConnections);
            this.put(PrometheusExporterUtils.join("sub.topic.num", "get sub topic num."), TcpSummaryMetrics::getSubTopicNum);
        }
    };

    public static void export(String meterName, TcpSummaryMetrics summaryMetrics) {
        Meter meter = GlobalMeterProvider.getMeter((String)meterName);
        paramPairs.forEach((metricInfo, getMetric) -> PrometheusExporterUtils.observeOfValue(meter, "eventmesh.tcp." + metricInfo[0], metricInfo[1], "TCP", (Metric)summaryMetrics, getMetric));
    }

    private PrometheusTcpExporter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

