/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import io.grpc.InternalLogId;
import io.grpc.internal.ServerListener;
import io.grpc.internal.ServerTransport;
import io.grpc.internal.ServerTransportListener;
import io.grpc.netty.LogIdAttachListener;
import io.grpc.netty.ServerListenerDelegator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LogIdServerListenerDelegator
implements ServerListenerDelegator {
    final Logger logger = LogManager.getLogger(this.getClass());

    @Override
    public ServerListener wrapServerListener(final ServerListener serverListener) {
        this.logger.info("ServerListener serverListener:{}", (Object)serverListener);
        ServerListener delegate = new ServerListener(){

            public ServerTransportListener transportCreated(ServerTransport transport) {
                InternalLogId logId = transport.getLogId();
                if (LogIdServerListenerDelegator.this.logger.isDebugEnabled()) {
                    LogIdServerListenerDelegator.this.logger.debug("transportCreated:{} {}", (Object)transport, (Object)logId);
                }
                ServerTransportListener serverTransportListener = serverListener.transportCreated(transport);
                return new LogIdAttachListener(serverTransportListener, logId.getId());
            }

            public void serverShutdown() {
                serverListener.serverShutdown();
            }
        };
        return delegate;
    }
}

