/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.metrics.grpc;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.eventmesh.common.EventMeshThreadFactory;
import org.apache.eventmesh.common.ThreadPoolFactory;
import org.apache.eventmesh.metrics.api.MetricsRegistry;
import org.apache.eventmesh.metrics.api.model.GrpcSummaryMetrics;
import org.apache.eventmesh.metrics.api.model.Metric;
import org.apache.eventmesh.runtime.boot.EventMeshGrpcServer;

public class EventMeshGrpcMonitor {
    private static final int DELAY_MILLS = 60000;
    private static final int SCHEDULE_PERIOD_MILLS = 60000;
    private static final int SCHEDULE_THREAD_SIZE = 1;
    private static final String THREAD_NAME_PREFIX = "eventMesh-grpc-monitor-scheduler";
    private final EventMeshGrpcServer eventMeshGrpcServer;
    private final List<MetricsRegistry> metricsRegistries;
    private final ScheduledExecutorService scheduler;
    private ScheduledFuture<?> scheduleTask;
    private final GrpcSummaryMetrics grpcSummaryMetrics;

    public EventMeshGrpcMonitor(EventMeshGrpcServer eventMeshGrpcServer, List<MetricsRegistry> metricsRegistries) {
        this.eventMeshGrpcServer = (EventMeshGrpcServer)Preconditions.checkNotNull((Object)eventMeshGrpcServer);
        this.metricsRegistries = (List)Preconditions.checkNotNull(metricsRegistries);
        this.grpcSummaryMetrics = new GrpcSummaryMetrics();
        this.scheduler = ThreadPoolFactory.createScheduledExecutor((int)1, (ThreadFactory)new EventMeshThreadFactory(THREAD_NAME_PREFIX, true));
    }

    public void init() throws Exception {
        this.metricsRegistries.forEach(MetricsRegistry::start);
    }

    public void start() throws Exception {
        this.metricsRegistries.forEach(metricsRegistry -> metricsRegistry.register((Metric)this.grpcSummaryMetrics));
        this.scheduleTask = this.scheduler.scheduleAtFixedRate(() -> {
            this.grpcSummaryMetrics.refreshTpsMetrics(60000L);
            this.grpcSummaryMetrics.clearAllMessageCounter();
            this.grpcSummaryMetrics.setRetrySize((long)this.eventMeshGrpcServer.getGrpcRetryer().size());
            this.grpcSummaryMetrics.setSubscribeTopicNum((long)this.eventMeshGrpcServer.getConsumerManager().getAllConsumerTopic().size());
        }, 60000L, 60000L, TimeUnit.MILLISECONDS);
    }

    public void recordReceiveMsgFromClient() {
        this.grpcSummaryMetrics.getClient2EventMeshMsgNum().incrementAndGet();
    }

    public void recordReceiveMsgFromClient(int count) {
        this.grpcSummaryMetrics.getClient2EventMeshMsgNum().addAndGet(count);
    }

    public void recordSendMsgToQueue() {
        this.grpcSummaryMetrics.getEventMesh2MqMsgNum().incrementAndGet();
    }

    public void recordReceiveMsgFromQueue() {
        this.grpcSummaryMetrics.getMq2EventMeshMsgNum().incrementAndGet();
    }

    public void recordSendMsgToClient() {
        this.grpcSummaryMetrics.getEventMesh2ClientMsgNum().incrementAndGet();
    }

    public void shutdown() throws Exception {
        this.scheduleTask.cancel(true);
        this.metricsRegistries.forEach(MetricsRegistry::showdown);
        this.scheduler.shutdown();
    }
}

