/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.grpc.processor;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.eventmesh.api.exception.AclException;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.common.protocol.grpc.cloudevents.CloudEvent;
import org.apache.eventmesh.common.protocol.grpc.common.EventMeshCloudEventUtils;
import org.apache.eventmesh.common.protocol.grpc.common.StatusCode;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.boot.EventMeshGrpcServer;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.ConsumerManager;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.EventMeshConsumer;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup.ConsumerGroupClient;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup.GrpcType;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.EventEmitter;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.ServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscribeProcessor {
    private static final Logger log = LoggerFactory.getLogger(SubscribeProcessor.class);
    private final transient EventMeshGrpcServer eventMeshGrpcServer;
    private final transient GrpcType grpcType = GrpcType.WEBHOOK;
    private final Acl acl;

    public SubscribeProcessor(EventMeshGrpcServer eventMeshGrpcServer) {
        this.eventMeshGrpcServer = eventMeshGrpcServer;
        this.acl = eventMeshGrpcServer.getAcl();
    }

    public void process(CloudEvent subscription, EventEmitter<CloudEvent> emitter) throws Exception {
        Objects.requireNonNull(subscription, "subscription can not be null");
        Objects.requireNonNull(emitter, "emitter can not be null");
        if (!ServiceUtils.validateCloudEventAttributes(subscription)) {
            ServiceUtils.sendResponseCompleted(StatusCode.EVENTMESH_PROTOCOL_HEADER_ERR, emitter);
            return;
        }
        if (!ServiceUtils.validateSubscription(this.grpcType, subscription)) {
            ServiceUtils.sendResponseCompleted(StatusCode.EVENTMESH_PROTOCOL_BODY_ERR, emitter);
            return;
        }
        try {
            this.doAclCheck(subscription);
        }
        catch (AclException e) {
            if (log.isWarnEnabled()) {
                log.warn("CLIENT HAS NO PERMISSION to Subscribe. failed", (Throwable)e);
            }
            ServiceUtils.sendResponseCompleted(StatusCode.EVENTMESH_ACL_ERR, e.getMessage(), emitter);
            return;
        }
        ConsumerManager consumerManager = this.eventMeshGrpcServer.getConsumerManager();
        String consumerGroup = EventMeshCloudEventUtils.getConsumerGroup((CloudEvent)subscription);
        List subscriptionItems = (List)JsonUtils.parseTypeReferenceObject((String)subscription.getTextData(), (TypeReference)new TypeReference<List<SubscriptionItem>>(){});
        String env = EventMeshCloudEventUtils.getEnv((CloudEvent)subscription);
        String idc = EventMeshCloudEventUtils.getIdc((CloudEvent)subscription);
        String sys = EventMeshCloudEventUtils.getSys((CloudEvent)subscription);
        String ip = EventMeshCloudEventUtils.getIp((CloudEvent)subscription);
        String pid = EventMeshCloudEventUtils.getPid((CloudEvent)subscription);
        String url = EventMeshCloudEventUtils.getURL((CloudEvent)subscription);
        LinkedList<ConsumerGroupClient> newClients = new LinkedList<ConsumerGroupClient>();
        for (SubscriptionItem item : subscriptionItems) {
            ConsumerGroupClient newClient = ConsumerGroupClient.builder().env(env).idc(idc).sys(sys).ip(ip).pid(pid).consumerGroup(consumerGroup).topic(item.getTopic()).grpcType(this.grpcType).subscriptionMode(item.getMode()).url(url).lastUpTime(new Date()).build();
            newClients.add(newClient);
        }
        newClients.forEach(consumerManager::registerClient);
        EventMeshConsumer eventMeshConsumer = consumerManager.getEventMeshConsumer(consumerGroup);
        boolean requireRestart = false;
        for (ConsumerGroupClient newClient : newClients) {
            if (!eventMeshConsumer.registerClient(newClient)) continue;
            requireRestart = true;
        }
        if (requireRestart) {
            if (log.isInfoEnabled()) {
                log.info("ConsumerGroup {} topic info changed, restart EventMesh Consumer", (Object)consumerGroup);
            }
            consumerManager.restartEventMeshConsumer(consumerGroup);
        } else if (log.isWarnEnabled()) {
            log.warn("EventMesh consumer [{}] didn't restart.", (Object)consumerGroup);
        }
        ServiceUtils.sendResponseCompleted(StatusCode.SUCCESS, "subscribe success", emitter);
    }

    private void doAclCheck(CloudEvent subscription) throws AclException {
        List subscriptionItems = (List)JsonUtils.parseTypeReferenceObject((String)subscription.getTextData(), (TypeReference)new TypeReference<List<SubscriptionItem>>(){});
        if (this.eventMeshGrpcServer.getEventMeshGrpcConfiguration().isEventMeshServerSecurityEnable()) {
            for (SubscriptionItem item : subscriptionItems) {
                this.acl.doAclCheckInHttpReceive(EventMeshCloudEventUtils.getConsumerGroup((CloudEvent)subscription), EventMeshCloudEventUtils.getUserName((CloudEvent)subscription), EventMeshCloudEventUtils.getPassword((CloudEvent)subscription), EventMeshCloudEventUtils.getSys((CloudEvent)subscription), item.getTopic(), RequestCode.SUBSCRIBE.getRequestCode());
            }
        }
    }
}

