/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.boot;

import org.apache.eventmesh.common.config.CommonConfiguration;
import org.apache.eventmesh.common.config.ConfigService;
import org.apache.eventmesh.common.utils.ConfigurationContextUtil;
import org.apache.eventmesh.runtime.boot.EventMeshBootstrap;
import org.apache.eventmesh.runtime.boot.EventMeshServer;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.configuration.EventMeshTCPConfiguration;

public class EventMeshTcpBootstrap
implements EventMeshBootstrap {
    private EventMeshTCPServer eventMeshTcpServer;
    private final EventMeshTCPConfiguration eventMeshTcpConfiguration;
    private final EventMeshServer eventMeshServer;

    public EventMeshTcpBootstrap(EventMeshServer eventMeshServer) {
        this.eventMeshServer = eventMeshServer;
        ConfigService configService = ConfigService.getInstance();
        this.eventMeshTcpConfiguration = (EventMeshTCPConfiguration)((Object)configService.buildConfigInstance(EventMeshTCPConfiguration.class));
        ConfigurationContextUtil.putIfAbsent((String)"TCP", (CommonConfiguration)this.eventMeshTcpConfiguration);
    }

    @Override
    public void init() throws Exception {
        if (this.eventMeshTcpConfiguration != null) {
            this.eventMeshTcpServer = new EventMeshTCPServer(this.eventMeshServer, this.eventMeshTcpConfiguration);
            this.eventMeshTcpServer.init();
        }
    }

    @Override
    public void start() throws Exception {
        if (this.eventMeshTcpConfiguration != null) {
            this.eventMeshTcpServer.start();
        }
    }

    @Override
    public void shutdown() throws Exception {
        if (this.eventMeshTcpConfiguration != null) {
            this.eventMeshTcpServer.shutdown();
        }
    }

    public EventMeshTCPServer getEventMeshTcpServer() {
        return this.eventMeshTcpServer;
    }

    public void setEventMeshTcpServer(EventMeshTCPServer eventMeshTcpServer) {
        this.eventMeshTcpServer = eventMeshTcpServer;
    }
}

