/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;

public abstract class SpanSimpleAroundInterceptor
implements AroundInterceptor {
    protected final PLogger logger;
    protected final boolean isDebug;
    protected final MethodDescriptor methodDescriptor;
    protected final TraceContext traceContext;

    protected SpanSimpleAroundInterceptor(TraceContext traceContext, MethodDescriptor methodDescriptor, Class<? extends SpanSimpleAroundInterceptor> childClazz) {
        this.traceContext = traceContext;
        this.methodDescriptor = methodDescriptor;
        this.logger = PLoggerFactory.getLogger(childClazz);
        this.isDebug = this.logger.isDebugEnabled();
    }

    @Override
    public void before(Object target, Object[] args) {
        block5: {
            if (this.isDebug) {
                this.logger.beforeInterceptor(target, args);
            }
            try {
                Trace trace = this.createTrace(target, args);
                if (trace == null) {
                    return;
                }
                if (!trace.canSampled()) {
                    return;
                }
                SpanRecorder recorder = trace.getSpanRecorder();
                this.doInBeforeTrace(recorder, target, args);
            }
            catch (Throwable th) {
                if (!this.logger.isWarnEnabled()) break block5;
                this.logger.warn("BEFORE. Caused:{}", (Object)th.getMessage(), (Object)th);
            }
        }
    }

    protected abstract void doInBeforeTrace(SpanRecorder var1, Object var2, Object[] var3);

    protected abstract Trace createTrace(Object var1, Object[] var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        Trace trace;
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args, result, throwable);
        }
        if ((trace = this.traceContext.currentRawTraceObject()) == null) {
            return;
        }
        if (!trace.canSampled()) {
            this.traceContext.removeTraceObject();
            return;
        }
        try {
            SpanRecorder recorder = trace.getSpanRecorder();
            this.doInAfterTrace(recorder, target, args, result, throwable);
        }
        catch (Throwable th) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("AFTER. Caused:{}", (Object)th.getMessage(), (Object)th);
            }
        }
        finally {
            this.traceContext.removeTraceObject();
            this.deleteTrace(trace, target, args, result, throwable);
        }
    }

    protected abstract void doInAfterTrace(SpanRecorder var1, Object var2, Object[] var3, Object var4, Throwable var5);

    protected void deleteTrace(Trace trace, Object target, Object[] args, Object result, Throwable throwable) {
        trace.close();
    }
}

