/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import java.util.Objects;

public abstract class SpanEventSimpleAroundInterceptorForPlugin
implements AroundInterceptor {
    protected final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    protected final boolean isDebug = this.logger.isDebugEnabled();
    protected final MethodDescriptor methodDescriptor;
    protected final TraceContext traceContext;

    protected SpanEventSimpleAroundInterceptorForPlugin(TraceContext traceContext, MethodDescriptor methodDescriptor) {
        this.traceContext = Objects.requireNonNull(traceContext, "traceContext");
        this.methodDescriptor = Objects.requireNonNull(methodDescriptor, "methodDescriptor");
    }

    @Override
    public void before(Object target, Object[] args) {
        block4: {
            if (this.isDebug) {
                this.logBeforeInterceptor(target, args);
            }
            this.prepareBeforeTrace(target, args);
            Trace trace = this.traceContext.currentTraceObject();
            if (trace == null) {
                return;
            }
            try {
                SpanEventRecorder recorder = trace.traceBlockBegin();
                this.doInBeforeTrace(recorder, target, args);
            }
            catch (Throwable th) {
                if (!this.logger.isWarnEnabled()) break block4;
                this.logger.warn("BEFORE. Caused:{}", (Object)th.getMessage(), (Object)th);
            }
        }
    }

    protected void logBeforeInterceptor(Object target, Object[] args) {
        this.logger.beforeInterceptor(target, args);
    }

    protected void prepareBeforeTrace(Object target, Object[] args) {
    }

    protected abstract void doInBeforeTrace(SpanEventRecorder var1, Object var2, Object[] var3) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        if (this.isDebug) {
            this.logAfterInterceptor(target, args, result, throwable);
        }
        this.prepareAfterTrace(target, args, result, throwable);
        Trace trace = this.traceContext.currentTraceObject();
        if (trace == null) {
            return;
        }
        try {
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            this.doInAfterTrace(recorder, target, args, result, throwable);
        }
        catch (Throwable th) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("AFTER error. Caused:{}", (Object)th.getMessage(), (Object)th);
            }
        }
        finally {
            trace.traceBlockEnd();
        }
    }

    protected void logAfterInterceptor(Object target, Object[] args, Object result, Throwable throwable) {
        this.logger.afterInterceptor(target, args, result, throwable);
    }

    protected void prepareAfterTrace(Object target, Object[] args, Object result, Throwable throwable) {
    }

    protected abstract void doInAfterTrace(SpanEventRecorder var1, Object var2, Object[] var3, Object var4, Throwable var5) throws Exception;

    protected MethodDescriptor getMethodDescriptor() {
        return this.methodDescriptor;
    }

    protected TraceContext getTraceContext() {
        return this.traceContext;
    }
}

