/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.instrument.matcher;

import com.navercorp.pinpoint.bootstrap.instrument.matcher.MultiClassBasedMatcher;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.operand.ClassInternalNameMatcherOperand;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.operand.MatcherOperand;
import com.navercorp.pinpoint.common.annotations.InterfaceStability;
import com.navercorp.pinpoint.common.util.CollectionUtils;
import java.util.List;

@InterfaceStability.Unstable
public class DefaultMultiClassBasedMatcher
implements MultiClassBasedMatcher {
    private final List<String> baseClassNames;
    private final MatcherOperand matcherOperand;

    DefaultMultiClassBasedMatcher(List<String> baseClassNames) {
        this(baseClassNames, null);
    }

    DefaultMultiClassBasedMatcher(List<String> baseClassNames, MatcherOperand additional) {
        if (CollectionUtils.isEmpty(baseClassNames)) {
            throw new IllegalArgumentException("basePackageNames must not be empty");
        }
        this.baseClassNames = baseClassNames;
        this.matcherOperand = this.getMatcherOperand(baseClassNames, additional);
    }

    private MatcherOperand getMatcherOperand(List<String> baseClassNames, MatcherOperand additional) {
        MatcherOperand operand = this.joinOr(baseClassNames);
        if (operand == null) {
            throw new IllegalStateException("operand is null");
        }
        if (additional == null) {
            return operand;
        }
        operand = operand.and(additional);
        return operand;
    }

    private MatcherOperand joinOr(List<String> baseClassNames) {
        MatcherOperand operand = null;
        for (String baseClassName : baseClassNames) {
            if (operand == null) {
                operand = new ClassInternalNameMatcherOperand(baseClassName);
                continue;
            }
            ClassInternalNameMatcherOperand classMatcherOperand = new ClassInternalNameMatcherOperand(baseClassName);
            operand = operand.or(classMatcherOperand);
        }
        return operand;
    }

    @Override
    public List<String> getBaseClassNames() {
        return this.baseClassNames;
    }

    @Override
    public MatcherOperand getMatcherOperand() {
        return this.matcherOperand;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultMultiClassBasedMatcher{");
        sb.append("baseClassNames=").append(this.baseClassNames);
        sb.append(", matcherOperand=").append(this.matcherOperand);
        sb.append('}');
        return sb.toString();
    }
}

