/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.classloader;

import com.navercorp.pinpoint.bootstrap.classloader.BootLoader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;

public class J9BootLoader
implements BootLoader {
    private static final ClassLoader bootstrapClassLoader = J9BootLoader.findBootstrapClassLoader();
    private static final Method findResource;
    private static final Method findResources;

    private static ClassLoader findBootstrapClassLoader() {
        Field bootstrapClassLoader;
        try {
            bootstrapClassLoader = ClassLoader.class.getDeclaredField("bootstrapClassLoader");
        }
        catch (NoSuchFieldException e) {
            try {
                bootstrapClassLoader = ClassLoader.class.getDeclaredField("systemClassLoader");
            }
            catch (NoSuchFieldException e2) {
                throw new IllegalStateException("bootstrapClassLoader not found Caused by:" + e.getMessage() + ", and " + e2.getMessage(), e2);
            }
        }
        try {
            bootstrapClassLoader.setAccessible(true);
            return (ClassLoader)bootstrapClassLoader.get(ClassLoader.class);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("bootstrapClassLoader access fail Caused by:" + e.getMessage(), e);
        }
    }

    private static Class<?> getAbstractClassLoader(String className) {
        try {
            return Class.forName(className, false, Object.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(className + " not found Caused by:" + e.getMessage(), e);
        }
    }

    private static Method getMethod(Class<?> bootstrapClassLoader, String methodName, Class<?> ... parameterTypes) {
        try {
            Method declaredMethod = bootstrapClassLoader.getDeclaredMethod(methodName, parameterTypes);
            declaredMethod.setAccessible(true);
            return declaredMethod;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(methodName + " not found Caused by:" + e.getMessage(), e);
        }
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        try {
            return (Enumeration)findResources.invoke((Object)bootstrapClassLoader, name);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("access fail Caused by:" + e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("invoke fail Caused by:" + e.getMessage(), e);
        }
    }

    @Override
    public URL findResource(String name) {
        try {
            return (URL)findResource.invoke((Object)bootstrapClassLoader, name);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("access fail Caused by:" + e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("invoke fail Caused by:" + e.getMessage(), e);
        }
    }

    @Override
    public Class<?> findBootstrapClassOrNull(ClassLoader classLoader, String name) {
        try {
            return bootstrapClassLoader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    static {
        Class<?> abstractClassLoader = J9BootLoader.getAbstractClassLoader("com.ibm.oti.vm.AbstractClassLoader");
        findResource = J9BootLoader.getMethod(abstractClassLoader, "findResource", String.class);
        findResources = J9BootLoader.getMethod(abstractClassLoader, "findResources", String.class);
    }
}

