/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.trace.pinpoint.exporter;

import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.common.trace.AnnotationKey;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.common.util.JvmUtils;
import com.navercorp.pinpoint.common.util.SystemPropertyKey;
import com.navercorp.pinpoint.grpc.AgentHeaderFactory;
import com.navercorp.pinpoint.grpc.client.ChannelFactory;
import com.navercorp.pinpoint.grpc.client.DefaultChannelFactoryBuilder;
import com.navercorp.pinpoint.grpc.client.HeaderFactory;
import com.navercorp.pinpoint.profiler.AgentInfoSender;
import com.navercorp.pinpoint.profiler.JvmInformation;
import com.navercorp.pinpoint.profiler.context.DefaultServerMetaDataRegistryService;
import com.navercorp.pinpoint.profiler.context.ServerMetaDataRegistryService;
import com.navercorp.pinpoint.profiler.context.Span;
import com.navercorp.pinpoint.profiler.context.SpanEvent;
import com.navercorp.pinpoint.profiler.context.annotation.Annotations;
import com.navercorp.pinpoint.profiler.context.compress.GrpcSpanProcessorV2;
import com.navercorp.pinpoint.profiler.context.compress.SpanProcessor;
import com.navercorp.pinpoint.profiler.context.grpc.GrpcAgentInfoMessageConverter;
import com.navercorp.pinpoint.profiler.context.grpc.GrpcSpanMessageConverter;
import com.navercorp.pinpoint.profiler.context.grpc.config.GrpcTransportConfig;
import com.navercorp.pinpoint.profiler.context.id.DefaultTraceId;
import com.navercorp.pinpoint.profiler.context.id.DefaultTraceRoot;
import com.navercorp.pinpoint.profiler.context.id.TraceRoot;
import com.navercorp.pinpoint.profiler.context.provider.AgentInformationProvider;
import com.navercorp.pinpoint.profiler.context.provider.grpc.DnsExecutorServiceProvider;
import com.navercorp.pinpoint.profiler.context.provider.grpc.GrpcNameResolverProvider;
import com.navercorp.pinpoint.profiler.context.thrift.MessageConverter;
import com.navercorp.pinpoint.profiler.monitor.metric.gc.JvmGcType;
import com.navercorp.pinpoint.profiler.receiver.ProfilerCommandLocatorBuilder;
import com.navercorp.pinpoint.profiler.sender.EnhancedDataSender;
import com.navercorp.pinpoint.profiler.sender.grpc.AgentGrpcDataSender;
import com.navercorp.pinpoint.profiler.sender.grpc.ReconnectExecutor;
import com.navercorp.pinpoint.profiler.sender.grpc.SimpleStreamState;
import com.navercorp.pinpoint.profiler.sender.grpc.SpanGrpcDataSender;
import com.navercorp.pinpoint.profiler.sender.grpc.StreamState;
import com.navercorp.pinpoint.profiler.util.AgentInfoFactory;
import io.grpc.NameResolverProvider;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.internal.OtelEncodingUtils;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.internal.ThrottlingLogger;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.data.EventData;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.data.StatusData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.common.utils.JsonUtils;

public final class PinpointSpanExporter
implements SpanExporter {
    private static final ThrottlingLogger THROTTLING_LOGGER = new ThrottlingLogger(Logger.getLogger(PinpointSpanExporter.class.getName()));
    private static final String AGENT_CHANNEL_FACTORY = "agentChannelFactory";
    private static final String SPAN_CHANNEL_FACTORY = "spanChannelFactory";
    private final long agentStartTime = System.currentTimeMillis();
    private final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
    private final ReconnectExecutor reconnectExecutor = new ReconnectExecutor(this.scheduledExecutorService);
    private final NameResolverProvider nameResolverProvider = new GrpcNameResolverProvider((Provider)new DnsExecutorServiceProvider()).get();
    private final String agentId;
    private final String agentName;
    private final String applicationName;
    private final GrpcTransportConfig grpcTransportConfig;
    private final HeaderFactory headerFactory;
    private final AgentInfoSender agentInfoSender;
    private final SpanGrpcDataSender spanGrpcDataSender;

    public PinpointSpanExporter(String agentId, String agentName, String applicationName, GrpcTransportConfig grpcTransportConfig) {
        this.agentId = Objects.requireNonNull(agentId, "agentId cannot be null");
        this.agentName = Objects.requireNonNull(agentName, "agentName cannot be null");
        this.applicationName = Objects.requireNonNull(applicationName, "applicationName cannot be  null");
        this.grpcTransportConfig = Objects.requireNonNull(grpcTransportConfig, "grpcTransportConfig cannot be  null");
        this.headerFactory = new AgentHeaderFactory(agentId, agentName, applicationName, (int)ServiceType.UNDEFINED.getCode(), this.agentStartTime);
        this.agentInfoSender = this.createAgentInfoSender();
        this.agentInfoSender.start();
        this.spanGrpcDataSender = this.createSpanGrpcDataSender();
    }

    private AgentInfoSender createAgentInfoSender() {
        ChannelFactory agentChannelFactory = this.createAgentChannelFactory();
        AgentGrpcDataSender agentGrpcDataSender = new AgentGrpcDataSender(this.grpcTransportConfig.getAgentCollectorIp(), this.grpcTransportConfig.getAgentCollectorPort(), this.grpcTransportConfig.getAgentSenderExecutorQueueSize(), (MessageConverter)new GrpcAgentInfoMessageConverter(), this.reconnectExecutor, this.scheduledExecutorService, agentChannelFactory, new ProfilerCommandLocatorBuilder().build());
        AgentInformationProvider agentInformationProvider = new AgentInformationProvider(this.agentId, this.agentName, this.applicationName, true, this.agentStartTime, ServiceType.STAND_ALONE);
        JvmInformation jvmInformation = new JvmInformation(JvmUtils.getSystemProperty((SystemPropertyKey)SystemPropertyKey.JAVA_VERSION), JvmGcType.UNKNOWN);
        DefaultServerMetaDataRegistryService serverMetaDataRegistryService = new DefaultServerMetaDataRegistryService(Collections.emptyList());
        serverMetaDataRegistryService.setServerName("eventmesh_trace");
        AgentInfoFactory agentInfoFactory = new AgentInfoFactory(agentInformationProvider.createAgentInformation(), (ServerMetaDataRegistryService)serverMetaDataRegistryService, jvmInformation);
        return new AgentInfoSender.Builder((EnhancedDataSender)agentGrpcDataSender, agentInfoFactory).build();
    }

    private SpanGrpcDataSender createSpanGrpcDataSender() {
        ChannelFactory spanChannelFactory = this.createSpanChannelFactory();
        GrpcSpanMessageConverter messageConverter = new GrpcSpanMessageConverter(this.agentId, ServiceType.STAND_ALONE.getCode(), (SpanProcessor)new GrpcSpanProcessorV2());
        SimpleStreamState streamState = new SimpleStreamState(this.grpcTransportConfig.getSpanClientOption().getLimitCount(), this.grpcTransportConfig.getSpanClientOption().getLimitTime());
        return new SpanGrpcDataSender(this.grpcTransportConfig.getSpanCollectorIp(), this.grpcTransportConfig.getSpanCollectorPort(), this.grpcTransportConfig.getSpanSenderExecutorQueueSize(), (MessageConverter)messageConverter, this.reconnectExecutor, spanChannelFactory, (StreamState)streamState);
    }

    private ChannelFactory createAgentChannelFactory() {
        DefaultChannelFactoryBuilder channelFactoryBuilder = new DefaultChannelFactoryBuilder(AGENT_CHANNEL_FACTORY);
        channelFactoryBuilder.setHeaderFactory(this.headerFactory);
        channelFactoryBuilder.setNameResolverProvider(this.nameResolverProvider);
        channelFactoryBuilder.setSslOption(this.grpcTransportConfig.getSslOption());
        channelFactoryBuilder.setClientOption(this.grpcTransportConfig.getAgentClientOption());
        channelFactoryBuilder.setExecutorQueueSize(this.grpcTransportConfig.getAgentChannelExecutorQueueSize());
        return channelFactoryBuilder.build();
    }

    private ChannelFactory createSpanChannelFactory() {
        DefaultChannelFactoryBuilder channelFactoryBuilder = new DefaultChannelFactoryBuilder(SPAN_CHANNEL_FACTORY);
        channelFactoryBuilder.setHeaderFactory(this.headerFactory);
        channelFactoryBuilder.setNameResolverProvider(this.nameResolverProvider);
        channelFactoryBuilder.setSslOption(this.grpcTransportConfig.getSslOption());
        channelFactoryBuilder.setClientOption(this.grpcTransportConfig.getSpanClientOption());
        channelFactoryBuilder.setExecutorQueueSize(this.grpcTransportConfig.getSpanChannelExecutorQueueSize());
        return channelFactoryBuilder.build();
    }

    public CompletableResultCode export(Collection<SpanData> spans) {
        if (spans.isEmpty()) {
            return CompletableResultCode.ofSuccess();
        }
        for (SpanData spanData : spans) {
            if (spanData == null) continue;
            try {
                if (this.spanGrpcDataSender.send((Object)this.toSpan(spanData))) continue;
                return CompletableResultCode.ofFailure();
            }
            catch (Exception e) {
                THROTTLING_LOGGER.log(Level.WARNING, "Failed to export span", (Throwable)e);
                return CompletableResultCode.ofFailure();
            }
        }
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        this.agentInfoSender.stop();
        this.spanGrpcDataSender.stop();
        try {
            this.scheduledExecutorService.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.reconnectExecutor.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return CompletableResultCode.ofSuccess();
    }

    private Span toSpan(SpanData spanData) {
        long startTimestamp = PinpointSpanExporter.toMillis(spanData.getStartEpochNanos());
        long transactionId = PinpointSpanExporter.hex32StringToLong(spanData.getTraceId());
        long spanId = PinpointSpanExporter.hex16StringToLong(spanData.getSpanId());
        long[] parentSpanId = new long[]{-1L};
        Optional.ofNullable(spanData.getParentSpanContext()).ifPresent(parentSpanContext -> {
            if (parentSpanContext.isValid()) {
                parentSpanId[0] = PinpointSpanExporter.hex16StringToLong(parentSpanContext.getSpanId());
            }
        });
        DefaultTraceId traceId = new DefaultTraceId(this.agentId, startTimestamp, transactionId, parentSpanId[0], spanId, (short)spanData.getKind().ordinal());
        DefaultTraceRoot traceRoot = new DefaultTraceRoot((TraceId)traceId, this.agentId, startTimestamp, transactionId);
        Span span = new Span((TraceRoot)traceRoot);
        StatusData statusData = spanData.getStatus();
        if (statusData != null) {
            Optional.ofNullable(traceRoot.getShared()).ifPresent(shared -> {
                shared.setRpcName(spanData.getName());
                shared.setEndPoint(PinpointSpanExporter.getEndpoint(spanData.getResource()));
                if (!StatusCode.OK.equals((Object)statusData.getStatusCode())) {
                    shared.maskErrorCode(statusData.getStatusCode().ordinal());
                    span.setExceptionInfo(statusData.getStatusCode().ordinal(), statusData.getDescription());
                }
            });
        }
        span.setStartTime(startTimestamp);
        long endTimestamp = PinpointSpanExporter.toMillis(spanData.getEndEpochNanos());
        span.setElapsedTime((int)(endTimestamp - startTimestamp));
        span.setServiceType(ServiceType.STAND_ALONE.getCode());
        span.setRemoteAddr("unknown");
        Optional.ofNullable(spanData.getAttributes()).ifPresent(attributes -> {
            span.addAnnotation(Annotations.of((int)AnnotationKey.HTTP_PARAM_ENTITY.getCode(), (String)JsonUtils.toJSONString((Object)attributes)));
            attributes.forEach((key, value) -> {
                if ("req0ip".equals(key.getKey())) {
                    span.setRemoteAddr(String.valueOf(value));
                }
            });
        });
        if (CollectionUtils.isNotEmpty((Collection)spanData.getEvents())) {
            AtomicInteger sequence = new AtomicInteger();
            span.setSpanEventList(spanData.getEvents().stream().map(event -> {
                SpanEvent spanEvent = this.toSpanEvent((EventData)event);
                spanEvent.setSequence(sequence.getAndIncrement());
                return spanEvent;
            }).collect(Collectors.toList()));
        }
        return span;
    }

    private SpanEvent toSpanEvent(EventData eventData) {
        SpanEvent spanEvent = new SpanEvent();
        spanEvent.setServiceType(ServiceType.INTERNAL_METHOD.getCode());
        spanEvent.setEndPoint(eventData.getName());
        spanEvent.addAnnotation(Annotations.of((int)AnnotationKey.HTTP_PARAM_ENTITY.getCode(), (String)JsonUtils.toJSONString((Object)eventData.getAttributes())));
        spanEvent.setElapsedTime((int)PinpointSpanExporter.toMillis(eventData.getEpochNanos()));
        return spanEvent;
    }

    private static long toMillis(long epochNanos) {
        return TimeUnit.NANOSECONDS.toMillis(epochNanos);
    }

    private static long hex32StringToLong(String hex32String) {
        StringBuilder charSequence = new StringBuilder().append(hex32String);
        return OtelEncodingUtils.isValidBase16String((CharSequence)charSequence) ? OtelEncodingUtils.longFromBase16String((CharSequence)charSequence, (int)0) & OtelEncodingUtils.longFromBase16String((CharSequence)charSequence, (int)16) : (long)hex32String.hashCode();
    }

    private static long hex16StringToLong(String hex16String) {
        StringBuilder charSequence = new StringBuilder().append(hex16String);
        return OtelEncodingUtils.isValidBase16String((CharSequence)charSequence) ? OtelEncodingUtils.longFromBase16String((CharSequence)charSequence, (int)0) : (long)hex16String.hashCode();
    }

    private static String getEndpoint(Resource resource) {
        if (resource == null) {
            return null;
        }
        Attributes resourceAttributes = resource.getAttributes();
        Objects.requireNonNull(resourceAttributes, "resourceAttributes can not be null");
        String serviceNameValue = (String)resourceAttributes.get(ResourceAttributes.SERVICE_NAME);
        if (serviceNameValue == null) {
            serviceNameValue = (String)Resource.getDefault().getAttributes().get(ResourceAttributes.SERVICE_NAME);
        }
        return serviceNameValue + "#" + IPUtils.getLocalAddress();
    }
}

