/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.util;

import com.navercorp.pinpoint.bootstrap.instrument.InterceptorScopeDefinition;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScopeInvocation;
import com.navercorp.pinpoint.profiler.util.ScopePool;
import com.navercorp.pinpoint.profiler.util.ThreadLocalScope;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ThreadLocalScopePool
implements ScopePool {
    private final ConcurrentMap<InterceptorScopeDefinition, InterceptorScopeInvocation> pool = new ConcurrentHashMap<InterceptorScopeDefinition, InterceptorScopeInvocation>();

    @Override
    public InterceptorScopeInvocation getScope(InterceptorScopeDefinition scopeDefinition) {
        Objects.requireNonNull(scopeDefinition, "scopeDefinition");
        InterceptorScopeInvocation scope = (InterceptorScopeInvocation)this.pool.get(scopeDefinition);
        if (scope != null) {
            return scope;
        }
        InterceptorScopeInvocation newScope = this.createScope(scopeDefinition);
        InterceptorScopeInvocation exist = this.pool.putIfAbsent(scopeDefinition, newScope);
        if (exist != null) {
            return exist;
        }
        return newScope;
    }

    private InterceptorScopeInvocation createScope(InterceptorScopeDefinition scopeDefinition) {
        return new ThreadLocalScope(scopeDefinition);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ScopePool{");
        sb.append("pool=").append(this.pool);
        sb.append('}');
        return sb.toString();
    }
}

