/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.transformer;

import com.navercorp.pinpoint.profiler.transformer.ClassFileFilter;
import com.navercorp.pinpoint.profiler.util.JavaAssistUtils;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UnmodifiableClassFilter
implements ClassFileFilter {
    private static final Object PRESENT = new Object();
    private final Map<String, Object> allowJdkClassNames;

    public UnmodifiableClassFilter() {
        this(Collections.emptyList());
    }

    public UnmodifiableClassFilter(List<String> allowJdkClassNames) {
        this.allowJdkClassNames = this.newJdkClassNameMap(allowJdkClassNames);
    }

    private Map<String, Object> newJdkClassNameMap(List<String> allowJdkClassNames) {
        HashMap<String, Object> allowJdkClass = new HashMap<String, Object>();
        for (String allowJdkClassName : allowJdkClassNames) {
            String jvmName = JavaAssistUtils.javaNameToJvmName(allowJdkClassName);
            allowJdkClass.put(jvmName, PRESENT);
        }
        return allowJdkClass;
    }

    @Override
    public boolean accept(ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classFileBuffer) {
        if (className == null) {
            return false;
        }
        if (className.startsWith("java") && (className.startsWith("/", 4) || className.startsWith("x/", 4))) {
            return this.allowJdkClassName(className);
        }
        return true;
    }

    private boolean allowJdkClassName(String className) {
        return this.allowJdkClassNames.containsKey(className);
    }
}

