/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.transformer;

import com.navercorp.pinpoint.profiler.transformer.ClassFileFilter;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class PinpointClassFilter
implements ClassFileFilter {
    public static final String DEFAULT_PACKAGE = "com/navercorp/pinpoint/";
    public static final List<String> DEFAULT_EXCLUDES = Collections.unmodifiableList(Arrays.asList("web/", "sdk/"));
    private final String basePackage;
    private final String[] excludes;

    public PinpointClassFilter() {
        this(DEFAULT_PACKAGE, DEFAULT_EXCLUDES);
    }

    public PinpointClassFilter(String basePackage, List<String> excludes) {
        this.basePackage = Objects.requireNonNull(basePackage, "basePackage");
        Objects.requireNonNull(excludes, "excludes");
        this.excludes = excludes.toArray(new String[0]);
    }

    @Override
    public boolean accept(ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classFileBuffer) {
        if (className == null) {
            return false;
        }
        if (className.startsWith(this.basePackage)) {
            for (String exclude : this.excludes) {
                if (!className.startsWith(exclude, this.basePackage.length())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public String toString() {
        return "PinpointClassFilter{basePackage='" + this.basePackage + '\'' + ", excludes=" + Arrays.toString(this.excludes) + '}';
    }
}

