/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.sender;

import com.navercorp.pinpoint.common.profiler.concurrent.PinpointThreadFactory;
import com.navercorp.pinpoint.profiler.sender.AsyncQueueingExecutorListener;
import com.navercorp.pinpoint.profiler.sender.UnsafeArrayCollection;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AsyncQueueingExecutor<T>
implements Runnable {
    private final Logger logger;
    private final boolean isWarn;
    private final LinkedBlockingQueue<T> queue;
    private final AtomicBoolean isRun = new AtomicBoolean(true);
    private final Thread executeThread;
    private final String executorName;
    private final int maxDrainSize;
    private final Collection<T> drain;
    private final AsyncQueueingExecutorListener<T> listener;

    public AsyncQueueingExecutor(int queueSize, String executorName, AsyncQueueingExecutorListener<T> listener) {
        Objects.requireNonNull(executorName, "executorName");
        this.logger = LogManager.getLogger((String)(this.getClass().getName() + "@" + executorName));
        this.isWarn = this.logger.isWarnEnabled();
        this.maxDrainSize = 10;
        this.drain = new UnsafeArrayCollection<T>(this.maxDrainSize);
        this.queue = new LinkedBlockingQueue(queueSize);
        this.executeThread = this.createExecuteThread(executorName);
        this.executorName = this.executeThread.getName();
        this.listener = Objects.requireNonNull(listener, "listener");
    }

    private Thread createExecuteThread(String executorName) {
        PinpointThreadFactory threadFactory = new PinpointThreadFactory(executorName, true);
        Thread thread = threadFactory.newThread(this);
        thread.start();
        return thread;
    }

    @Override
    public void run() {
        this.logger.info("{} started.", (Object)this.executorName);
        this.doExecute();
    }

    private void doExecute() {
        long timeout = 2000L;
        block2: while (this.isRun()) {
            try {
                Collection<T> dtoList = this.getDrainQueue();
                int drainSize = this.takeN(dtoList, this.maxDrainSize);
                if (drainSize > 0) {
                    this.doExecute((T)dtoList);
                    continue;
                }
                while (this.isRun()) {
                    T dto = this.takeOne(timeout);
                    if (dto != null) {
                        this.doExecute(dto);
                        continue block2;
                    }
                    this.pollTimeout(timeout);
                }
            }
            catch (Throwable th) {
                this.logger.warn("{} doExecute(). Unexpected Error. Cause:{}", (Object)this.executorName, (Object)th.getMessage(), (Object)th);
            }
        }
        this.flushQueue();
    }

    private void flushQueue() {
        Collection<T> dtoList;
        int drainSize;
        boolean debugEnabled = this.logger.isDebugEnabled();
        if (debugEnabled) {
            this.logger.debug("Loop is stop.");
        }
        while ((drainSize = this.takeN(dtoList = this.getDrainQueue(), this.maxDrainSize)) != 0) {
            if (debugEnabled) {
                this.logger.debug("flushData size {}", (Object)drainSize);
            }
            this.doExecute((T)dtoList);
        }
    }

    private T takeOne(long timeout) {
        try {
            return this.queue.poll(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    private int takeN(Collection<T> drain, int maxDrainSize) {
        return this.queue.drainTo(drain, maxDrainSize);
    }

    protected void pollTimeout(long timeout) {
    }

    public boolean execute(T data) {
        if (data == null) {
            if (this.isWarn) {
                this.logger.warn("execute(). data is null");
            }
            return false;
        }
        if (!this.isRun.get()) {
            if (this.isWarn) {
                this.logger.warn("{} is shutdown. discard data:{}", (Object)this.executorName, data);
            }
            return false;
        }
        boolean offer = this.queue.offer(data);
        if (!offer && this.isWarn) {
            this.logger.warn("{} Drop data. queue is full. size:{}", (Object)this.executorName, (Object)this.queue.size());
        }
        return offer;
    }

    private void doExecute(Collection<T> dtoList) {
        this.listener.execute(dtoList);
    }

    private void doExecute(T dto) {
        this.listener.execute(dto);
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public boolean isRun() {
        return this.isRun.get();
    }

    public void stop() {
        this.isRun.set(false);
        if (!this.isEmpty()) {
            this.logger.info("Wait 5 seconds. Flushing queued data.");
        }
        this.executeThread.interrupt();
        try {
            this.executeThread.join(5000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logger.warn("{} stopped incompletely.", (Object)this.executorName);
        }
        this.logger.info("{} stopped.", (Object)this.executorName);
    }

    Collection<T> getDrainQueue() {
        this.drain.clear();
        return this.drain;
    }
}

