/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.sampler;

import com.navercorp.pinpoint.bootstrap.sampler.Sampler;
import com.navercorp.pinpoint.common.util.MathUtils;
import java.util.concurrent.atomic.AtomicLong;

public class PercentRateSampler
implements Sampler {
    public static final long MULTIPLIER = 100L;
    public static final long MAX = 10000L;
    private final AtomicLong counter = new AtomicLong(0L);
    private final long samplingRate;

    public PercentRateSampler(long samplingRate) {
        if (samplingRate <= 0L || samplingRate >= 10000L) {
            throw new IllegalArgumentException("Invalid samplingRate " + samplingRate);
        }
        this.samplingRate = samplingRate;
    }

    public boolean isSampling() {
        long seed = this.counter.addAndGet(this.samplingRate);
        long remainder = MathUtils.floorMod((long)seed, (long)10000L);
        return remainder > 0L && remainder <= this.samplingRate;
    }

    public String toString() {
        return "PercentRateSampler{seedGen=" + this.counter + ", samplingRate=" + this.samplingRate + '}';
    }
}

