/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.receiver.service;

import com.navercorp.pinpoint.common.util.ThreadMXBeanUtils;
import com.navercorp.pinpoint.profiler.context.active.ActiveTraceRepository;
import com.navercorp.pinpoint.profiler.context.active.ActiveTraceSnapshot;
import com.navercorp.pinpoint.profiler.receiver.service.LimitedList;
import com.navercorp.pinpoint.profiler.receiver.service.StackTrace;
import com.navercorp.pinpoint.profiler.receiver.service.ThreadDump;
import com.navercorp.pinpoint.profiler.receiver.service.ThreadDumpComparator;
import com.navercorp.pinpoint.profiler.receiver.service.ThreadDumpRequest;
import java.lang.management.ThreadInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public class ActiveThreadDumpCoreService {
    private final ActiveTraceRepository activeTraceRepository;
    private final Comparator<ThreadDump> reverseOrder = Collections.reverseOrder(new ThreadDumpComparator());

    public ActiveThreadDumpCoreService(ActiveTraceRepository activeTraceRepository) {
        this.activeTraceRepository = Objects.requireNonNull(activeTraceRepository, "activeTraceRepository");
    }

    public Collection<ThreadDump> getActiveThreadDumpList(ThreadDumpRequest request) {
        List<ActiveTraceSnapshot> activeTraceInfoList = this.activeTraceRepository.snapshot();
        return this.getActiveThreadDumpList(activeTraceInfoList, request);
    }

    private Collection<ThreadDump> getActiveThreadDumpList(List<ActiveTraceSnapshot> activeTraceInfoList, ThreadDumpRequest request) {
        if (request.isEnableFilter()) {
            return this.filterActiveThreadDump(activeTraceInfoList, request);
        }
        return this.getAllActiveThreadDump(activeTraceInfoList, request);
    }

    private Collection<ThreadDump> filterActiveThreadDump(List<ActiveTraceSnapshot> activeTraceInfoList, ThreadDumpRequest request) {
        LimitedList<ThreadDump> result = new LimitedList<ThreadDump>(request.getLimit(), this.reverseOrder);
        for (ActiveTraceSnapshot activeTraceInfo : activeTraceInfoList) {
            ThreadDump threadDump;
            long threadId = activeTraceInfo.getThreadId();
            if (!this.isTraceThread(threadId) || (threadDump = this.filter(activeTraceInfo, request)) == null) continue;
            result.add(threadDump);
        }
        return result;
    }

    private ThreadDump filter(ActiveTraceSnapshot activeTraceInfo, ThreadDumpRequest request) {
        long threadId;
        ThreadInfo threadInfo;
        long threadId2;
        ThreadInfo threadInfo2;
        long localTransactionId;
        if (request.isEnableLocalTransactionIdFilter() && request.findLocalTransactionId(localTransactionId = activeTraceInfo.getLocalTransactionId()) && (threadInfo2 = this.getThreadInfo(threadId2 = activeTraceInfo.getThreadId(), request.getStackTrace())) != null) {
            return this.newThreadDump(activeTraceInfo, threadInfo2);
        }
        if (request.isEnableThreadNameFilter() && (threadInfo = this.getThreadInfo(threadId = activeTraceInfo.getThreadId(), request.getStackTrace())) != null && request.findThreadName(threadInfo.getThreadName())) {
            return this.newThreadDump(activeTraceInfo, threadInfo);
        }
        return null;
    }

    private Collection<ThreadDump> getAllActiveThreadDump(List<ActiveTraceSnapshot> activeTraceInfoList, ThreadDumpRequest request) {
        LimitedList<ThreadDump> activeThreadDumpList = new LimitedList<ThreadDump>(request.getLimit(), this.reverseOrder);
        for (ActiveTraceSnapshot activeTraceInfo : activeTraceInfoList) {
            ThreadInfo threadInfo;
            long threadId = activeTraceInfo.getThreadId();
            if (!this.isTraceThread(threadId) || (threadInfo = this.getThreadInfo(threadId, request.getStackTrace())) == null) continue;
            ThreadDump threadDump = this.newThreadDump(activeTraceInfo, threadInfo);
            activeThreadDumpList.add(threadDump);
        }
        return activeThreadDumpList;
    }

    private boolean isTraceThread(long threadId) {
        return threadId != -1L;
    }

    private ThreadInfo getThreadInfo(long threadId, StackTrace dumpType) {
        if (threadId == -1L) {
            return null;
        }
        if (StackTrace.DUMP == dumpType) {
            return ThreadMXBeanUtils.getThreadInfo((long)threadId);
        }
        return ThreadMXBeanUtils.getThreadInfo((long)threadId, (int)0);
    }

    private ThreadDump newThreadDump(ActiveTraceSnapshot activeTraceInfo, ThreadInfo threadInfo) {
        return new ThreadDump(activeTraceInfo, threadInfo);
    }
}

