/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.receiver;

import com.google.inject.Inject;
import com.navercorp.pinpoint.io.request.Message;
import com.navercorp.pinpoint.profiler.receiver.ProfilerCommandService;
import com.navercorp.pinpoint.profiler.receiver.ProfilerCommandServiceLocator;
import com.navercorp.pinpoint.profiler.receiver.ProfilerRequestCommandService;
import com.navercorp.pinpoint.profiler.receiver.ProfilerStreamCommandService;
import com.navercorp.pinpoint.rpc.MessageListener;
import com.navercorp.pinpoint.rpc.PinpointSocket;
import com.navercorp.pinpoint.rpc.packet.RequestPacket;
import com.navercorp.pinpoint.rpc.packet.SendPacket;
import com.navercorp.pinpoint.rpc.packet.stream.StreamClosePacket;
import com.navercorp.pinpoint.rpc.packet.stream.StreamCode;
import com.navercorp.pinpoint.rpc.packet.stream.StreamCreatePacket;
import com.navercorp.pinpoint.rpc.stream.ServerStreamChannel;
import com.navercorp.pinpoint.rpc.stream.ServerStreamChannelMessageHandler;
import com.navercorp.pinpoint.thrift.dto.TResult;
import com.navercorp.pinpoint.thrift.io.CommandHeaderTBaseDeserializerFactory;
import com.navercorp.pinpoint.thrift.io.CommandHeaderTBaseSerializerFactory;
import com.navercorp.pinpoint.thrift.io.DeserializerFactory;
import com.navercorp.pinpoint.thrift.io.SerializerFactory;
import com.navercorp.pinpoint.thrift.util.SerializationUtils;
import java.io.Closeable;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.thrift.TBase;

public class CommandDispatcher
extends ServerStreamChannelMessageHandler
implements MessageListener {
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final ProfilerCommandServiceLocator<TBase<?, ?>, TBase<?, ?>> commandServiceLocator;
    private final CommandHeaderTBaseSerializerFactory commandHeaderTBaseSerializerFactory = CommandHeaderTBaseSerializerFactory.getDefaultInstance();
    private final CommandHeaderTBaseDeserializerFactory commandHeaderTBaseDeserializerFactory = CommandHeaderTBaseDeserializerFactory.getDefaultInstance();

    @Inject
    public CommandDispatcher(ProfilerCommandServiceLocator<TBase<?, ?>, TBase<?, ?>> commandServiceLocator) {
        this.commandServiceLocator = Objects.requireNonNull(commandServiceLocator, "commandServiceLocator");
    }

    public void handleSend(SendPacket sendPacket, PinpointSocket pinpointSocket) {
        this.logger.info("handleSend packet:{}, remote:{}", (Object)sendPacket, (Object)pinpointSocket.getRemoteAddress());
    }

    public void handleRequest(RequestPacket requestPacket, PinpointSocket pinpointSocket) {
        TBase<?, ?> response;
        byte[] payload;
        this.logger.info("handleRequest packet:{}, remote:{}", (Object)requestPacket, (Object)pinpointSocket.getRemoteAddress());
        Message message = SerializationUtils.deserialize((byte[])requestPacket.getPayload(), (DeserializerFactory)this.commandHeaderTBaseDeserializerFactory, null);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("handleRequest request:{}, remote:{}", (Object)message, (Object)pinpointSocket.getRemoteAddress());
        }
        if ((payload = SerializationUtils.serialize(response = this.processRequest(message), (SerializerFactory)this.commandHeaderTBaseSerializerFactory, null)) != null) {
            pinpointSocket.response(requestPacket.getRequestId(), payload);
        }
    }

    private TBase<?, ?> processRequest(Message<TBase<?, ?>> message) {
        if (message == null) {
            TResult tResult = new TResult(false);
            tResult.setMessage("Unsupported ServiceTypeInfo.");
            return tResult;
        }
        short type = message.getHeader().getType();
        ProfilerRequestCommandService<TBase<?, ?>, TBase<?, ?>> service = this.commandServiceLocator.getRequestService(type);
        if (service == null) {
            TResult tResult = new TResult(false);
            tResult.setMessage("Can't find suitable service(" + message + ").");
            return tResult;
        }
        TBase request = (TBase)message.getData();
        TBase<?, ?> tResponse = service.requestCommandService(request);
        return tResponse;
    }

    public StreamCode handleStreamCreatePacket(ServerStreamChannel streamChannel, StreamCreatePacket packet) {
        this.logger.info("handleStreamCreatePacket() streamChannel:{}, packet:{}", (Object)streamChannel, (Object)packet);
        Message message = SerializationUtils.deserialize((byte[])packet.getPayload(), (DeserializerFactory)this.commandHeaderTBaseDeserializerFactory, null);
        if (message == null) {
            return StreamCode.TYPE_UNKNOWN;
        }
        short type = message.getHeader().getType();
        ProfilerStreamCommandService<TBase<?, ?>> service = this.commandServiceLocator.getStreamService(type);
        if (service == null) {
            return StreamCode.TYPE_UNSUPPORT;
        }
        TBase request = (TBase)message.getData();
        return service.streamCommandService(request, streamChannel);
    }

    public void handleStreamClosePacket(ServerStreamChannel streamChannel, StreamClosePacket packet) {
        this.logger.info("handleStreamClosePacket() streamChannel:{}, packet:{}", (Object)streamChannel, (Object)packet);
    }

    public Set<Short> getRegisteredCommandServiceCodes() {
        return this.commandServiceLocator.getCommandServiceCodes();
    }

    public void close() {
        this.logger.info("close() started");
        Set<Short> commandServiceCodes = this.commandServiceLocator.getCommandServiceCodes();
        for (Short commandServiceCode : commandServiceCodes) {
            ProfilerCommandService service = this.commandServiceLocator.getService(commandServiceCode);
            if (!(service instanceof Closeable)) continue;
            try {
                ((Closeable)((Object)service)).close();
            }
            catch (Exception e) {
                this.logger.warn("failed to close for CommandService:{}. message:{}", (Object)service, (Object)e.getMessage());
            }
        }
        this.logger.info("close() completed");
    }

    public String toString() {
        return "CommandDispatcher{" + this.commandServiceLocator.getCommandServiceCodes() + '}';
    }
}

