/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.plugin;

import com.navercorp.pinpoint.profiler.plugin.ClassNameFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PinpointProfilerPackageSkipFilter
implements ClassNameFilter {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final String[] packageList;

    public PinpointProfilerPackageSkipFilter() {
        this(PinpointProfilerPackageSkipFilter.getPinpointPackageList());
    }

    public PinpointProfilerPackageSkipFilter(List<String> packageList) {
        Objects.requireNonNull(packageList, "packageList");
        this.packageList = packageList.toArray(new String[0]);
    }

    @Override
    public boolean accept(String className) {
        Objects.requireNonNull(className, "className");
        for (String packageName : this.packageList) {
            if (!className.startsWith(packageName)) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.info("skip ProfilerPackage:{} Class:{}", (Object)packageName, (Object)className);
            }
            return false;
        }
        return true;
    }

    private static List<String> getPinpointPackageList() {
        ArrayList<String> pinpointPackageList = new ArrayList<String>();
        pinpointPackageList.add("com.navercorp.pinpoint.bootstrap");
        pinpointPackageList.add("com.navercorp.pinpoint.profiler");
        pinpointPackageList.add("com.navercorp.pinpoint.common");
        pinpointPackageList.add("com.navercorp.pinpoint.exception");
        pinpointPackageList.add("com.navercorp.pinpoint.test");
        return pinpointPackageList;
    }
}

