/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.objectfactory;

import com.navercorp.pinpoint.profiler.objectfactory.ArgumentProvider;
import com.navercorp.pinpoint.profiler.objectfactory.JudgingParameterResolver;
import com.navercorp.pinpoint.profiler.objectfactory.Option;
import java.lang.annotation.Annotation;
import java.util.List;

public class ArgumentsResolver {
    private final List<ArgumentProvider> parameterResolvers;

    public ArgumentsResolver(List<ArgumentProvider> parameterResolvers) {
        this.parameterResolvers = parameterResolvers;
    }

    public Object[] resolve(Class<?>[] types, Annotation[][] annotations) {
        int length = types.length;
        Object[] arguments = new Object[length];
        for (ArgumentProvider resolver : this.parameterResolvers) {
            if (!(resolver instanceof JudgingParameterResolver)) continue;
            ((JudgingParameterResolver)resolver).prepare();
        }
        for (int i = 0; i < length; ++i) {
            Option resolved;
            block4: {
                for (ArgumentProvider resolver : this.parameterResolvers) {
                    resolved = resolver.get(i, types[i], annotations[i]);
                    if (!resolved.hasValue()) continue;
                    break block4;
                }
                return null;
            }
            arguments[i] = resolved.getValue();
        }
        for (ArgumentProvider resolver : this.parameterResolvers) {
            if (!(resolver instanceof JudgingParameterResolver) || ((JudgingParameterResolver)resolver).isAcceptable()) continue;
            return null;
        }
        return arguments;
    }
}

