/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.jdbc;

import com.navercorp.pinpoint.bootstrap.plugin.jdbc.SqlModule;
import com.navercorp.pinpoint.common.util.ArrayUtils;
import com.navercorp.pinpoint.common.util.StringUtils;
import com.navercorp.pinpoint.profiler.jdbc.Converter;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.UUID;

public class ObjectConverter
implements Converter {
    private static final boolean SQL_MODULE = SqlModule.isSqlModuleEnable();
    private static final Class<?> SQL_DATE = SqlModule.getSqlDate();
    private static final Class<?> SQL_TIME = SqlModule.getSqlTime();
    private static final Class<?> SQL_TIMESTAMP = SqlModule.getSqlTimestamp();
    private static final Class<?> SQL_CLOB = SqlModule.getSqlClob();
    private static final Class<?> SQL_BLOB = SqlModule.getSqlBlob();
    private final int maxWidth;

    public ObjectConverter() {
        this(32);
    }

    public ObjectConverter(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    @Override
    public String convert(Object[] args) {
        if (args == null) {
            return "null";
        }
        int length = args.length;
        if (length == 2) {
            Object param = args[1];
            return this.getParameter(param);
        }
        if (length == 3) {
            Object param = args[1];
            return this.getParameter(param);
        }
        return "error";
    }

    private String getParameter(Object param) {
        if (param == null) {
            return "null";
        }
        if (param instanceof String) {
            return this.abbreviate(param);
        }
        if (param instanceof Boolean) {
            return this.toString(param);
        }
        if (param instanceof Integer) {
            return this.toString(param);
        }
        if (param instanceof Long) {
            return this.toString(param);
        }
        if (param instanceof Short) {
            return this.toString(param);
        }
        if (param instanceof Float) {
            return this.toString(param);
        }
        if (param instanceof Double) {
            return this.toString(param);
        }
        if (param instanceof Byte) {
            return this.toString(param);
        }
        if (param instanceof UUID) {
            return this.toString(param);
        }
        if (param instanceof byte[]) {
            return ArrayUtils.abbreviate((byte[])((byte[])param), (int)this.maxWidth);
        }
        if (param instanceof InputStream) {
            return this.getClassName(param);
        }
        if (param instanceof BigDecimal) {
            return this.toString(param);
        }
        if (param instanceof BigInteger) {
            return this.toString(param);
        }
        if (SQL_MODULE) {
            if (SQL_DATE.isInstance(param)) {
                return this.toString(param);
            }
            if (SQL_TIME.isInstance(param)) {
                return this.toString(param);
            }
            if (SQL_TIMESTAMP.isInstance(param)) {
                return this.toString(param);
            }
            if (SQL_BLOB.isInstance(param)) {
                return this.getClassName(param);
            }
            if (SQL_CLOB.isInstance(param)) {
                return this.getClassName(param);
            }
        }
        return this.getClassName(param);
    }

    private String abbreviate(Object param) {
        return StringUtils.abbreviate((String)param.toString(), (int)this.maxWidth);
    }

    private String toString(Object param) {
        return param.toString();
    }

    private String getClassName(Object param) {
        return param.getClass().getName();
    }
}

