/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument.config;

import com.navercorp.pinpoint.bootstrap.config.Filter;
import com.navercorp.pinpoint.bootstrap.config.ProfilableClassFilter;
import com.navercorp.pinpoint.bootstrap.config.SkipFilter;
import com.navercorp.pinpoint.bootstrap.config.Value;
import com.navercorp.pinpoint.common.util.StringUtils;
import com.navercorp.pinpoint.profiler.instrument.config.InstrumentConfig;
import java.util.Collections;
import java.util.List;

public class DefaultInstrumentConfig
implements InstrumentConfig {
    public static final String INSTRUMENT_ENGINE_ASM = "ASM";
    @Value(value="${profiler.instrument.engine}")
    private String profileInstrumentEngine = "ASM";
    @Value(value="${profiler.instrument.matcher.enable}")
    private boolean instrumentMatcherEnable = true;
    @Value(value="${profiler.interceptorregistry.size}")
    private int interceptorRegistrySize = 8192;
    private List<String> allowJdkClassNames = Collections.emptyList();
    @Value(value="${profiler.pinpoint.base-package}")
    private String pinpointBasePackage;
    @Value(value="${profiler.pinpoint.exclude-package}")
    private String pinpointExcludePackage;
    private int callStackMaxDepth = 64;
    private int callStackMaxSequence = 5000;
    private Filter<String> profilableClassFilter = new SkipFilter();
    @Value(value="${profiler.applicationservertype}")
    private String applicationServerType = null;
    @Value(value="${profiler.interceptor.exception.propagate}")
    private boolean propagateInterceptorException = false;
    @Value(value="${profiler.lambda.expressions.support}")
    private boolean supportLambdaExpressions = true;

    @Override
    public int getInterceptorRegistrySize() {
        return this.interceptorRegistrySize;
    }

    @Override
    public List<String> getAllowJdkClassName() {
        return this.allowJdkClassNames;
    }

    @Value(value="${profiler.instrument.jdk.allow.classnames}")
    void setAllowJdkClassNames(String allowJdkClassNames) {
        this.allowJdkClassNames = StringUtils.tokenizeToStringList((String)allowJdkClassNames, (String)",");
    }

    @Override
    public String getPinpointBasePackage() {
        return this.pinpointBasePackage;
    }

    @Override
    public String getPinpointExcludeSubPackage() {
        return this.pinpointExcludePackage;
    }

    @Override
    public Filter<String> getProfilableClassFilter() {
        return this.profilableClassFilter;
    }

    @Value(value="${profiler.include}")
    void setProfilableClassFilter(String profilableClass) {
        this.profilableClassFilter = profilableClass != null && !profilableClass.isEmpty() ? new ProfilableClassFilter(profilableClass) : new SkipFilter();
    }

    @Override
    public String getApplicationServerType() {
        return this.applicationServerType;
    }

    public void setApplicationServerType(String applicationServerType) {
        this.applicationServerType = applicationServerType;
    }

    @Override
    public int getCallStackMaxDepth() {
        return this.callStackMaxDepth;
    }

    @Override
    public int getCallStackMaxSequence() {
        return this.callStackMaxSequence;
    }

    @Value(value="${profiler.callstack.max.depth}")
    public void setCallStackMaxDepth(int callStackMaxDepth) {
        if (callStackMaxDepth != -1 && callStackMaxDepth < 2) {
            callStackMaxDepth = 2;
        }
        this.callStackMaxDepth = callStackMaxDepth;
    }

    @Value(value="${profiler.callstack.max.sequence}")
    public void setCallStackMaxSequence(int callStackMaxSequence) {
        int minLimit = 4;
        if (callStackMaxSequence >= 0 && callStackMaxSequence < 4) {
            callStackMaxSequence = 4;
        } else if (callStackMaxSequence < 0 || callStackMaxSequence > Short.MAX_VALUE) {
            callStackMaxSequence = Short.MAX_VALUE;
        }
        this.callStackMaxSequence = callStackMaxSequence;
    }

    @Override
    public boolean isPropagateInterceptorException() {
        return this.propagateInterceptorException;
    }

    @Override
    public String getProfileInstrumentEngine() {
        return this.profileInstrumentEngine;
    }

    @Override
    public boolean isSupportLambdaExpressions() {
        return this.supportLambdaExpressions;
    }

    @Override
    public boolean isInstrumentMatcherEnable() {
        return this.instrumentMatcherEnable;
    }

    public String toString() {
        return "DefaultInstrumentConfig{profileInstrumentEngine='" + this.profileInstrumentEngine + '\'' + ", instrumentMatcherEnable=" + this.instrumentMatcherEnable + ", interceptorRegistrySize=" + this.interceptorRegistrySize + ", allowJdkClassNames=" + this.allowJdkClassNames + ", pinpointBasePackage='" + this.pinpointBasePackage + '\'' + ", pinpointExcludePackage='" + this.pinpointExcludePackage + '\'' + ", callStackMaxDepth=" + this.callStackMaxDepth + ", profilableClassFilter=" + this.profilableClassFilter + ", applicationServerType='" + this.applicationServerType + '\'' + ", propagateInterceptorException=" + this.propagateInterceptorException + ", supportLambdaExpressions=" + this.supportLambdaExpressions + '}';
    }
}

