/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.recorder;

import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.plugin.uri.DisabledUriStatRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.uri.UriExtractor;
import com.navercorp.pinpoint.bootstrap.plugin.uri.UriExtractorProviderLocator;
import com.navercorp.pinpoint.bootstrap.plugin.uri.UriExtractorService;
import com.navercorp.pinpoint.bootstrap.plugin.uri.UriStatRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.uri.UriStatRecorderFactory;
import com.navercorp.pinpoint.profiler.context.recorder.DefaultUriStatRecorder;
import com.navercorp.pinpoint.profiler.context.storage.UriStatStorage;
import java.util.Objects;

public class DefaultUriStatRecorderFactory
implements UriStatRecorderFactory {
    private final UriExtractorProviderLocator uriExtractorProviderLocator;
    private final UriStatStorage uriStatStorage;

    public DefaultUriStatRecorderFactory(Provider<UriExtractorProviderLocator> uriExtractorProviderLocatorProvider, Provider<UriStatStorage> uriStatStorageProvider) {
        Objects.requireNonNull(uriExtractorProviderLocatorProvider, "uriExtractorProviderLocatorProvider");
        UriExtractorProviderLocator uriExtractorProviderLocator = (UriExtractorProviderLocator)uriExtractorProviderLocatorProvider.get();
        this.uriExtractorProviderLocator = Objects.requireNonNull(uriExtractorProviderLocator, "uriExtractorProviderLocator");
        Objects.requireNonNull(uriStatStorageProvider, "uriStatStorageProvider");
        this.uriStatStorage = (UriStatStorage)uriStatStorageProvider.get();
    }

    public <T> UriStatRecorder<T> create(UriExtractorService<T> uriExtractorService) {
        Objects.requireNonNull(uriExtractorService, "uriExtractorService");
        UriExtractor uriExtractor = uriExtractorService.get(this.uriExtractorProviderLocator);
        if (uriExtractor == null) {
            return DisabledUriStatRecorder.create();
        }
        return new DefaultUriStatRecorder(uriExtractor, this.uriStatStorage);
    }
}

