/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider.thrift;

import com.navercorp.pinpoint.common.util.ByteSizeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractClientFactoryProvider {
    protected final Logger logger = LogManager.getLogger(this.getClass());

    protected int getByteSize(String value, int defaultSize) {
        try {
            long byteSize = ByteSizeUnit.getByteSize((String)value);
            if (byteSize > Integer.MAX_VALUE) {
                this.logger.warn("must be writeBufferWaterMark({}) range is 0 ~ {}", (Object)value, (Object)Integer.MAX_VALUE);
                byteSize = Integer.MAX_VALUE;
            } else if (byteSize <= 0L) {
                this.logger.warn("must be writeBufferWaterMark({}) range is 0 ~ {}", (Object)value, (Object)Integer.MAX_VALUE);
                byteSize = defaultSize;
            }
            return (int)byteSize;
        }
        catch (Exception e) {
            this.logger.warn("Failed to get byteSize({}). byteSize will be defaultSize:{}", (Object)value, (Object)defaultSize);
            return defaultSize;
        }
    }
}

