/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.id;

import com.navercorp.pinpoint.bootstrap.context.AsyncState;
import com.navercorp.pinpoint.common.annotations.InterfaceAudience;
import com.navercorp.pinpoint.profiler.context.active.ActiveTraceHandle;
import java.util.Objects;

@InterfaceAudience.LimitedPrivate(value={"vert.x"})
public class ListenableAsyncState
implements AsyncState {
    private final AsyncStateListener asyncStateListener;
    private final ActiveTraceHandle activeTraceHandle;
    private boolean setup = false;
    private boolean await = false;
    private boolean finish = false;

    public ListenableAsyncState(AsyncStateListener asyncStateListener, ActiveTraceHandle activeTraceHandle) {
        this.asyncStateListener = Objects.requireNonNull(asyncStateListener, "asyncStateListener");
        this.activeTraceHandle = Objects.requireNonNull(activeTraceHandle, "activeTraceHandle");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        boolean finished = false;
        ListenableAsyncState listenableAsyncState = this;
        synchronized (listenableAsyncState) {
            if (this.await && !this.finish) {
                finished = true;
            }
            this.finish = true;
        }
        if (finished) {
            this.asyncStateListener.finish();
            long purgeTime = System.currentTimeMillis();
            this.activeTraceHandle.purge(purgeTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setup() {
        ListenableAsyncState listenableAsyncState = this;
        synchronized (listenableAsyncState) {
            this.setup = true;
        }
    }

    public boolean await() {
        boolean await = this.await0();
        if (!await) {
            long purgeTime = System.currentTimeMillis();
            this.activeTraceHandle.purge(purgeTime);
        }
        return await;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean await0() {
        ListenableAsyncState listenableAsyncState = this;
        synchronized (listenableAsyncState) {
            if (!this.setup || this.finish) {
                return false;
            }
            this.await = true;
            return true;
        }
    }

    public String toString() {
        return "ListenableAsyncState{asyncStateListener=" + this.asyncStateListener + ", setup=" + this.setup + ", await=" + this.await + ", finish=" + this.finish + '}';
    }

    @InterfaceAudience.LimitedPrivate(value={"LocalTraceContext"})
    public static interface AsyncStateListener {
        public void finish();
    }
}

