/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.id;

import com.navercorp.pinpoint.profiler.context.id.Shared;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultShared
implements Shared {
    private static final Logger logger = LogManager.getLogger(DefaultShared.class);
    private static final AtomicReferenceFieldUpdater<DefaultShared, String> END_POINT_UPDATER = AtomicReferenceFieldUpdater.newUpdater(DefaultShared.class, String.class, "endPoint");
    private static final AtomicReferenceFieldUpdater<DefaultShared, String> RPC_UPDATER = AtomicReferenceFieldUpdater.newUpdater(DefaultShared.class, String.class, "rpc");
    private volatile int errorCode;
    private volatile byte loggingInfo;
    private volatile String endPoint;
    private volatile String rpc;
    private volatile long threadId;
    private volatile int statusCode;

    @Override
    public void maskErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    @Override
    public int getErrorCode() {
        return this.errorCode;
    }

    @Override
    public void setLoggingInfo(byte loggingInfo) {
        this.loggingInfo = loggingInfo;
    }

    @Override
    public byte getLoggingInfo() {
        return this.loggingInfo;
    }

    @Override
    public void setEndPoint(String endPoint) {
        boolean updated = END_POINT_UPDATER.compareAndSet(this, null, endPoint);
        if (!updated) {
            logger.debug("already set EndPoint {}", (Object)endPoint);
        }
    }

    @Override
    public String getEndPoint() {
        return END_POINT_UPDATER.get(this);
    }

    @Override
    public void setRpcName(String rpc) {
        boolean updated = RPC_UPDATER.compareAndSet(this, null, rpc);
        if (!updated) {
            logger.debug("already set Rpc {}", (Object)rpc);
        }
    }

    @Override
    public String getRpcName() {
        return RPC_UPDATER.get(this);
    }

    @Override
    public void setThreadId(long threadId) {
        this.threadId = threadId;
    }

    @Override
    public long getThreadId() {
        return this.threadId;
    }

    @Override
    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }
}

