/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.grpc.config;

import com.navercorp.pinpoint.bootstrap.config.Value;
import com.navercorp.pinpoint.bootstrap.config.util.ValueAnnotationProcessor;
import com.navercorp.pinpoint.bootstrap.util.spring.PropertyPlaceholderHelper;
import com.navercorp.pinpoint.grpc.client.config.ClientOption;
import com.navercorp.pinpoint.grpc.client.config.SslOption;
import java.util.Properties;

public class GrpcTransportConfig {
    public static final String SYSTEM_PROPERTY_NETTY_TRY_REFLECTION_SET_ACCESSIBLE = "io.netty.tryReflectionSetAccessible";
    public static final String KEY_PROFILER_CONFIG_NETTY_TRY_REFLECTION_SET_ACCESSIBLE = "profiler.system.property.io.netty.tryReflectionSetAccessible";
    public static final String SYSTEM_PROPERTY_NETTY_NOPREFERDIRECT = "io.netty.noPreferDirect";
    public static final String KEY_PROFILER_CONFIG_NETTY_NOPREFERDIRECT = "profiler.system.property.io.netty.noPreferDirect";
    private static final String DEFAULT_IP = "127.0.0.1";
    private static final long DEFAULT_CLIENT_REQUEST_TIMEOUT = 6000L;
    private static final int DEFAULT_AGENT_SENDER_EXECUTOR_QUEUE_SIZE = 1000;
    private static final int DEFAULT_METADATA_SENDER_EXECUTOR_QUEUE_SIZE = 1000;
    private static final int DEFAULT_SPAN_SENDER_EXECUTOR_QUEUE_SIZE = 1000;
    private static final int DEFAULT_STAT_SENDER_EXECUTOR_QUEUE_SIZE = 1000;
    private static final int DEFAULT_AGENT_COLLECTOR_PORT = 9991;
    private static final int DEFAULT_STAT_COLLECTOR_PORT = 9992;
    private static final int DEFAULT_SPAN_COLLECTOR_PORT = 9993;
    private static final int DEFAULT_AGENT_CHANNEL_EXECUTOR_QUEUE_SIZE = 1000;
    private static final int DEFAULT_METADATA_CHANNEL_EXECUTOR_QUEUE_SIZE = 1000;
    private static final int DEFAULT_STAT_CHANNEL_EXECUTOR_QUEUE_SIZE = 1000;
    private static final int DEFAULT_SPAN_CHANNEL_EXECUTOR_QUEUE_SIZE = 1000;
    private static final boolean DEFAULT_SSL = false;
    private static final int DEFAULT_DISCARD_LOG_RATE_LIMIT = 100;
    private static final long DEFAULT_DISCARD_MAX_PENDING_THRESHOLD = 1024L;
    private static final long DEFAULT_DISCARD_COUNT_FOR_RECONNECT = 1000L;
    private static final long DEFAULT_NOT_READY_TIMEOUT_MILLIS = 300000L;
    private static final int DEFAULT_METADATA_RETRY_MAX_COUNT = 3;
    private static final int DEFAULT_METADATA_RETRY_DELAY_MILLIS = 1000;
    public static final boolean DEFAULT_NETTY_SYSTEM_PROPERTY_TRY_REFLECTIVE_SET_ACCESSIBLE = true;
    private ClientOption agentClientOption = new ClientOption();
    private ClientOption metadataClientOption = new ClientOption();
    private ClientOption statClientOption = new ClientOption();
    private ClientOption spanClientOption = new ClientOption();
    private SslOption sslOption = null;
    @Value(value="${profiler.transport.grpc.agent.collector.ip}")
    private String agentCollectorIp = "127.0.0.1";
    @Value(value="${profiler.transport.grpc.agent.collector.port}")
    private int agentCollectorPort = 9991;
    @Value(value="${profiler.transport.grpc.agent.ssl.enable}")
    private boolean agentSslEnable = false;
    @Value(value="${profiler.transport.grpc.agent.sender.request.timeout.millis}")
    private long agentRequestTimeout = 6000L;
    @Value(value="${profiler.transport.grpc.agent.sender.executor.queue.size}")
    private int agentSenderExecutorQueueSize = 1000;
    @Value(value="${profiler.transport.grpc.agent.sender.channel.executor.queue.size}")
    private int agentChannelExecutorQueueSize = 1000;
    @Value(value="${profiler.transport.grpc.metadata.collector.ip}")
    private String metadataCollectorIp = "127.0.0.1";
    @Value(value="${profiler.transport.grpc.metadata.collector.port}")
    private int metadataCollectorPort = 9991;
    @Value(value="${profiler.transport.grpc.metadata.ssl.enable}")
    private boolean metadataSslEnable = false;
    @Value(value="${profiler.transport.grpc.metadata.sender.request.timeout.millis}")
    private long metadataRequestTimeout = 6000L;
    @Value(value="${profiler.transport.grpc.metadata.sender.executor.queue.size}")
    private int metadataSenderExecutorQueueSize = 1000;
    @Value(value="${profiler.transport.grpc.metadata.sender.channel.executor.queue.size}")
    private int metadataChannelExecutorQueueSize = 1000;
    @Value(value="${profiler.transport.grpc.metadata.sender.retry.max.count}")
    private int metadataRetryMaxCount = 3;
    @Value(value="${profiler.transport.grpc.metadata.sender.retry.delay.millis}")
    private int metadataRetryDelayMillis = 1000;
    @Value(value="${profiler.transport.grpc.stat.collector.ip}")
    private String statCollectorIp = "127.0.0.1";
    @Value(value="${profiler.transport.grpc.stat.collector.port}")
    private int statCollectorPort = 9992;
    @Value(value="${profiler.transport.grpc.stat.ssl.enable}")
    private boolean statSslEnable = false;
    @Value(value="${profiler.transport.grpc.stat.sender.request.timeout.millis}")
    private long statRequestTimeout = 6000L;
    @Value(value="${profiler.transport.grpc.stat.sender.executor.queue.size}")
    private int statSenderExecutorQueueSize = 1000;
    @Value(value="${profiler.transport.grpc.stat.sender.channel.executor.queue.size}")
    private int statChannelExecutorQueueSize = 1000;
    @Value(value="${profiler.transport.grpc.span.collector.ip}")
    private String spanCollectorIp = "127.0.0.1";
    @Value(value="${profiler.transport.grpc.span.collector.port}")
    private int spanCollectorPort = 9993;
    @Value(value="${profiler.transport.grpc.span.ssl.enable}")
    private boolean spanSslEnable = false;
    @Value(value="${profiler.transport.grpc.span.sender.request.timeout.millis}")
    private long spanRequestTimeout = 6000L;
    @Value(value="${profiler.transport.grpc.span.sender.executor.queue.size}")
    private int spanSenderExecutorQueueSize = 1000;
    @Value(value="${profiler.transport.grpc.span.sender.channel.executor.queue.size}")
    private int spanChannelExecutorQueueSize = 1000;
    @Value(value="${profiler.transport.grpc.span.sender.discardpolicy.logger.discard.ratelimit}")
    private int spanDiscardLogRateLimit = 100;
    @Value(value="${profiler.transport.grpc.span.sender.discardpolicy.maxpendingthreshold}")
    private long spanDiscardMaxPendingThreshold = 1024L;
    @Value(value="${profiler.transport.grpc.span.sender.discardpolicy.discard-count-for-reconnect}")
    private long spanDiscardCountForReconnect = 1000L;
    @Value(value="${profiler.transport.grpc.span.sender.discardpolicy.not-ready-timeout-millis}")
    private long spanNotReadyTimeoutMillis = 300000L;
    @Value(value="${profiler.system.property.io.netty.tryReflectionSetAccessible}")
    private boolean nettySystemPropertyTryReflectiveSetAccessible = true;

    public void read(Properties properties) {
        SslOption sslOption;
        ValueAnnotationProcessor reader = new ValueAnnotationProcessor();
        reader.process((Object)this, properties);
        this.agentClientOption = this.readAgentClientOption(properties);
        this.metadataClientOption = this.readMetadataClientOption(properties);
        this.statClientOption = this.readStatClientOption(properties);
        this.spanClientOption = this.readSpanClientOption(properties);
        this.sslOption = sslOption = this.readSslOption(properties);
    }

    private ClientOption readAgentClientOption(Properties properties) {
        return this.readClientOption(properties, "profiler.transport.grpc.agent.sender.");
    }

    private ClientOption readMetadataClientOption(Properties properties) {
        return this.readClientOption(properties, "profiler.transport.grpc.metadata.sender.");
    }

    private ClientOption readStatClientOption(Properties properties) {
        return this.readClientOption(properties, "profiler.transport.grpc.stat.sender.");
    }

    private ClientOption readSpanClientOption(Properties properties) {
        return this.readClientOption(properties, "profiler.transport.grpc.span.sender.");
    }

    private ClientOption readClientOption(final Properties properties, final String transportName) {
        ClientOption clientOption = new ClientOption();
        ValueAnnotationProcessor reader = new ValueAnnotationProcessor();
        reader.process((Object)clientOption, new PropertyPlaceholderHelper.PlaceholderResolver(){

            public String resolvePlaceholder(String placeholderName) {
                String prefix = transportName + placeholderName;
                return properties.getProperty(prefix);
            }
        });
        return clientOption;
    }

    public SslOption readSslOption(final Properties properties) {
        String sslPrefix = "profiler.transport.grpc.ssl.";
        String agentRootPath = properties.getProperty("pinpoint.agent.root.path");
        SslOption.Builder builder = new SslOption.Builder(agentRootPath);
        ValueAnnotationProcessor reader = new ValueAnnotationProcessor();
        reader.process((Object)builder, new PropertyPlaceholderHelper.PlaceholderResolver(){

            public String resolvePlaceholder(String placeholderName) {
                String prefix = "profiler.transport.grpc.ssl." + placeholderName;
                return properties.getProperty(prefix);
            }
        });
        return builder.build();
    }

    public String getAgentCollectorIp() {
        return this.agentCollectorIp;
    }

    public int getAgentCollectorPort() {
        return this.agentCollectorPort;
    }

    public boolean isAgentSslEnable() {
        return this.agentSslEnable;
    }

    public String getMetadataCollectorIp() {
        return this.metadataCollectorIp;
    }

    public int getMetadataCollectorPort() {
        return this.metadataCollectorPort;
    }

    public boolean isMetadataSslEnable() {
        return this.metadataSslEnable;
    }

    public String getStatCollectorIp() {
        return this.statCollectorIp;
    }

    public int getStatCollectorPort() {
        return this.statCollectorPort;
    }

    public boolean isStatSslEnable() {
        return this.statSslEnable;
    }

    public String getSpanCollectorIp() {
        return this.spanCollectorIp;
    }

    public int getSpanCollectorPort() {
        return this.spanCollectorPort;
    }

    public boolean isSpanSslEnable() {
        return this.spanSslEnable;
    }

    public int getAgentSenderExecutorQueueSize() {
        return this.agentSenderExecutorQueueSize;
    }

    public int getMetadataSenderExecutorQueueSize() {
        return this.metadataSenderExecutorQueueSize;
    }

    public int getSpanSenderExecutorQueueSize() {
        return this.spanSenderExecutorQueueSize;
    }

    public int getStatSenderExecutorQueueSize() {
        return this.statSenderExecutorQueueSize;
    }

    public int getSpanDiscardLogRateLimit() {
        return this.spanDiscardLogRateLimit;
    }

    public long getSpanDiscardMaxPendingThreshold() {
        return this.spanDiscardMaxPendingThreshold;
    }

    public long getSpanDiscardCountForReconnect() {
        return this.spanDiscardCountForReconnect;
    }

    public long getSpanNotReadyTimeoutMillis() {
        return this.spanNotReadyTimeoutMillis;
    }

    public long getAgentRequestTimeout() {
        return this.agentRequestTimeout;
    }

    public long getMetadataRequestTimeout() {
        return this.metadataRequestTimeout;
    }

    public long getStatRequestTimeout() {
        return this.statRequestTimeout;
    }

    public long getSpanRequestTimeout() {
        return this.spanRequestTimeout;
    }

    public ClientOption getAgentClientOption() {
        return this.agentClientOption;
    }

    public ClientOption getMetadataClientOption() {
        return this.metadataClientOption;
    }

    public ClientOption getStatClientOption() {
        return this.statClientOption;
    }

    public ClientOption getSpanClientOption() {
        return this.spanClientOption;
    }

    public SslOption getSslOption() {
        return this.sslOption;
    }

    public int getAgentChannelExecutorQueueSize() {
        return this.agentChannelExecutorQueueSize;
    }

    public int getMetadataChannelExecutorQueueSize() {
        return this.metadataChannelExecutorQueueSize;
    }

    public int getStatChannelExecutorQueueSize() {
        return this.statChannelExecutorQueueSize;
    }

    public int getSpanChannelExecutorQueueSize() {
        return this.spanChannelExecutorQueueSize;
    }

    public int getMetadataRetryMaxCount() {
        return this.metadataRetryMaxCount;
    }

    public int getMetadataRetryDelayMillis() {
        return this.metadataRetryDelayMillis;
    }

    public boolean isNettySystemPropertyTryReflectiveSetAccessible() {
        return this.nettySystemPropertyTryReflectiveSetAccessible;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("GrpcTransportConfig{");
        sb.append("agentCollectorIp='").append(this.agentCollectorIp).append('\'');
        sb.append(", agentCollectorPort=").append(this.agentCollectorPort);
        sb.append(", agentSslEnable=").append(this.agentSslEnable);
        sb.append(", metadataCollectorIp='").append(this.metadataCollectorIp).append('\'');
        sb.append(", metadataCollectorPort=").append(this.metadataCollectorPort);
        sb.append(", metadataSslEnable=").append(this.metadataSslEnable);
        sb.append(", statCollectorIp='").append(this.statCollectorIp).append('\'');
        sb.append(", statCollectorPort=").append(this.statCollectorPort);
        sb.append(", statSslEnable=").append(this.statSslEnable);
        sb.append(", spanCollectorIp='").append(this.spanCollectorIp).append('\'');
        sb.append(", spanCollectorPort=").append(this.spanCollectorPort);
        sb.append(", spanSslEnable=").append(this.spanSslEnable);
        sb.append(", agentClientOption=").append(this.agentClientOption);
        sb.append(", metadataClientOption=").append(this.metadataClientOption);
        sb.append(", statClientOption=").append(this.statClientOption);
        sb.append(", spanClientOption=").append(this.spanClientOption);
        sb.append(", sslOption=").append(this.sslOption);
        sb.append(", agentSenderExecutorQueueSize=").append(this.agentSenderExecutorQueueSize);
        sb.append(", metadataSenderExecutorQueueSize=").append(this.metadataSenderExecutorQueueSize);
        sb.append(", spanSenderExecutorQueueSize=").append(this.spanSenderExecutorQueueSize);
        sb.append(", statSenderExecutorQueueSize=").append(this.statSenderExecutorQueueSize);
        sb.append(", agentChannelExecutorQueueSize=").append(this.agentChannelExecutorQueueSize);
        sb.append(", metadataChannelExecutorQueueSize=").append(this.metadataChannelExecutorQueueSize);
        sb.append(", statChannelExecutorQueueSize=").append(this.statChannelExecutorQueueSize);
        sb.append(", spanChannelExecutorQueueSize=").append(this.spanChannelExecutorQueueSize);
        sb.append(", agentRequestTimeout=").append(this.agentRequestTimeout);
        sb.append(", metadataRequestTimeout=").append(this.metadataRequestTimeout);
        sb.append(", spanRequestTimeout=").append(this.spanRequestTimeout);
        sb.append(", statRequestTimeout=").append(this.statRequestTimeout);
        sb.append(", metadataRetryMaxCount=").append(this.metadataRetryMaxCount);
        sb.append(", metadataRetryDelayMillis=").append(this.metadataRetryDelayMillis);
        sb.append(", nettySystemPropertyTryReflectiveSetAccessible=").append(this.nettySystemPropertyTryReflectiveSetAccessible);
        sb.append(", spanDiscardLogRateLimit=").append(this.spanDiscardLogRateLimit);
        sb.append(", spanDiscardMaxPendingThreshold=").append(this.spanDiscardMaxPendingThreshold);
        sb.append('}');
        return sb.toString();
    }
}

