/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.grpc;

import com.navercorp.pinpoint.common.trace.UriStatHistogramBucket;
import com.navercorp.pinpoint.grpc.trace.PAgentUriStat;
import com.navercorp.pinpoint.grpc.trace.PEachUriStat;
import com.navercorp.pinpoint.grpc.trace.PUriHistogram;
import com.navercorp.pinpoint.profiler.context.thrift.MessageConverter;
import com.navercorp.pinpoint.profiler.monitor.metric.MetricType;
import com.navercorp.pinpoint.profiler.monitor.metric.uri.AgentUriStatData;
import com.navercorp.pinpoint.profiler.monitor.metric.uri.EachUriStatData;
import com.navercorp.pinpoint.profiler.monitor.metric.uri.UriStatHistogram;
import java.util.Collection;

public class GrpcUriStatMessageConverter
implements MessageConverter<MetricType, PAgentUriStat> {
    private static final PUriHistogram EMPTY_DETAILED_DATA_INSTANCE = PUriHistogram.getDefaultInstance();

    @Override
    public PAgentUriStat toMessage(MetricType message) {
        if (!(message instanceof AgentUriStatData)) {
            return null;
        }
        return this.createPAgentUriStat((AgentUriStatData)message);
    }

    private PAgentUriStat createPAgentUriStat(AgentUriStatData agentUriStatData) {
        long baseTimestamp = agentUriStatData.getBaseTimestamp();
        PAgentUriStat.Builder builder = PAgentUriStat.newBuilder();
        builder.setTimestamp(baseTimestamp);
        builder.setBucketVersion((int)UriStatHistogramBucket.getBucketVersion());
        Collection<EachUriStatData> allUriStatData = agentUriStatData.getAllUriStatData();
        for (EachUriStatData eachUriStatData : allUriStatData) {
            PEachUriStat pEachUriStat = this.createPEachUriStat(eachUriStatData);
            builder.addEachUriStat(pEachUriStat);
        }
        return builder.build();
    }

    private PEachUriStat createPEachUriStat(EachUriStatData eachUriStatData) {
        String uri = eachUriStatData.getUri();
        PEachUriStat.Builder builder = PEachUriStat.newBuilder();
        builder.setUri(uri);
        UriStatHistogram totalHistogram = eachUriStatData.getTotalHistogram();
        PUriHistogram totalPUriHistogram = this.createPUriHistogram(totalHistogram);
        builder.setTotalHistogram(totalPUriHistogram);
        UriStatHistogram failedHistogram = eachUriStatData.getFailedHistogram();
        PUriHistogram failedPUriHistogram = this.createPUriHistogram(failedHistogram);
        builder.setFailedHistogram(failedPUriHistogram);
        return builder.build();
    }

    private PUriHistogram createPUriHistogram(UriStatHistogram uriStatHistogram) {
        int[] timestampHistograms;
        int count = uriStatHistogram.getCount();
        if (uriStatHistogram.getCount() == 0) {
            return EMPTY_DETAILED_DATA_INSTANCE;
        }
        PUriHistogram.Builder builder = PUriHistogram.newBuilder();
        long total = uriStatHistogram.getTotal();
        long max = uriStatHistogram.getMax();
        builder.setCount(count);
        builder.setAvg((double)(total / (long)count));
        builder.setMax(max);
        for (int eachTimestampHistogram : timestampHistograms = uriStatHistogram.getTimestampHistogram()) {
            builder.addHistogram(eachTimestampHistogram);
        }
        return builder.build();
    }
}

