/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.compress;

import com.navercorp.pinpoint.common.annotations.VisibleForTesting;
import com.navercorp.pinpoint.common.util.CollectionUtils;
import com.navercorp.pinpoint.profiler.context.Span;
import com.navercorp.pinpoint.profiler.context.SpanChunk;
import com.navercorp.pinpoint.profiler.context.SpanEvent;
import com.navercorp.pinpoint.profiler.context.TraceDataFormatVersion;
import com.navercorp.pinpoint.profiler.context.compress.SpanProcessor;
import com.navercorp.pinpoint.profiler.context.id.TraceRoot;
import com.navercorp.pinpoint.thrift.dto.TSpan;
import com.navercorp.pinpoint.thrift.dto.TSpanChunk;
import com.navercorp.pinpoint.thrift.dto.TSpanEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;

public class SpanProcessorV1
implements SpanProcessor<TSpan, TSpanChunk> {
    private static final byte V1 = TraceDataFormatVersion.V1.getVersion();

    @Override
    public void preProcess(Span span, TSpan tSpan) {
        if (tSpan.getVersion() != V1) {
            tSpan.setVersion(V1);
        }
    }

    @Override
    public void preProcess(SpanChunk spanChunk, TSpanChunk tSpanChunk) {
        if (tSpanChunk.getVersion() != V1) {
            tSpanChunk.setVersion(V1);
        }
    }

    @Override
    public void postProcess(Span span, TSpan tSpan) {
        List<TSpanEvent> tSpanEventList;
        TraceRoot traceRoot = span.getTraceRoot();
        long keyTime = traceRoot.getTraceStartTime();
        List<SpanEvent> spanEventList = span.getSpanEventList();
        if (spanEventList == null) {
            spanEventList = Collections.emptyList();
        }
        if ((tSpanEventList = tSpan.getSpanEventList()) == null) {
            tSpanEventList = Collections.emptyList();
        }
        this.postEventProcess(spanEventList, tSpanEventList, keyTime);
    }

    @Override
    public void postProcess(SpanChunk spanChunk, TSpanChunk tSpanChunk) {
        TraceRoot traceRoot = spanChunk.getTraceRoot();
        long keyTime = traceRoot.getTraceStartTime();
        List<SpanEvent> spanEventList = spanChunk.getSpanEventList();
        if (CollectionUtils.isEmpty(spanEventList)) {
            throw new IllegalStateException("SpanChunk.spanEventList is empty");
        }
        List tSpanEventList = tSpanChunk.getSpanEventList();
        if (CollectionUtils.isEmpty((Collection)tSpanEventList)) {
            throw new IllegalStateException("TSpanChunk.spanEventList is empty");
        }
        this.postEventProcess(spanEventList, tSpanEventList, keyTime);
    }

    @VisibleForTesting
    public void postEventProcess(List<SpanEvent> spanEventList, List<TSpanEvent> tSpanEventList, long keyTime) {
        if (CollectionUtils.isEmpty(spanEventList)) {
            return;
        }
        if (CollectionUtils.nullSafeSize(spanEventList) != CollectionUtils.nullSafeSize(tSpanEventList)) {
            throw new IllegalStateException("list size not same, spanEventList=" + CollectionUtils.nullSafeSize(spanEventList) + ", tSpanEventList=" + CollectionUtils.nullSafeSize(tSpanEventList));
        }
        assert (spanEventList instanceof RandomAccess);
        int listSize = spanEventList.size();
        for (int i = 0; i < listSize; ++i) {
            SpanEvent spanEvent = spanEventList.get(i);
            TSpanEvent tSpanEvent = tSpanEventList.get(i);
            long startTime = spanEvent.getStartTime();
            long startElapsedTime = startTime - keyTime;
            tSpanEvent.setStartElapsed((int)startElapsedTime);
        }
    }
}

