/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.annotation;

import com.navercorp.pinpoint.grpc.trace.PAnnotationValue;
import com.navercorp.pinpoint.profiler.context.Annotation;
import com.navercorp.pinpoint.profiler.context.grpc.GrpcAnnotationSerializable;
import com.navercorp.pinpoint.profiler.context.grpc.GrpcAnnotationValueMapper;
import com.navercorp.pinpoint.profiler.context.thrift.AnnotationValueThriftMapper;
import com.navercorp.pinpoint.profiler.context.thrift.ThriftAnnotationSerializable;
import com.navercorp.pinpoint.thrift.dto.TAnnotationValue;

public class ByteAnnotation
implements Annotation<Byte>,
GrpcAnnotationSerializable,
ThriftAnnotationSerializable {
    private final int key;
    private final byte value;

    ByteAnnotation(int key, byte value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public int getAnnotationKey() {
        return this.getKey();
    }

    @Override
    public int getKey() {
        return this.key;
    }

    @Override
    public Byte getValue() {
        return this.value;
    }

    @Override
    public PAnnotationValue apply(GrpcAnnotationValueMapper context) {
        PAnnotationValue.Builder builder = context.getAnnotationBuilder();
        builder.setByteValue((int)this.value);
        return builder.build();
    }

    @Override
    public TAnnotationValue apply(AnnotationValueThriftMapper context) {
        return TAnnotationValue.byteValue((byte)this.value);
    }

    public String toString() {
        return "ByteAnnotation{" + this.key + "=" + this.value + '}';
    }
}

