/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context;

import com.navercorp.pinpoint.bootstrap.context.SpanRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.bootstrap.sampler.TraceSampler;
import com.navercorp.pinpoint.common.annotations.InterfaceAudience;
import com.navercorp.pinpoint.profiler.context.AsyncChildTrace;
import com.navercorp.pinpoint.profiler.context.AsyncSpanChunkFactory;
import com.navercorp.pinpoint.profiler.context.AsyncTrace;
import com.navercorp.pinpoint.profiler.context.BaseTraceFactory;
import com.navercorp.pinpoint.profiler.context.CallStack;
import com.navercorp.pinpoint.profiler.context.CallStackFactory;
import com.navercorp.pinpoint.profiler.context.DefaultSpanChunkFactory;
import com.navercorp.pinpoint.profiler.context.DefaultTrace;
import com.navercorp.pinpoint.profiler.context.DisableAsyncChildTrace;
import com.navercorp.pinpoint.profiler.context.DisableTrace;
import com.navercorp.pinpoint.profiler.context.LocalAsyncId;
import com.navercorp.pinpoint.profiler.context.Span;
import com.navercorp.pinpoint.profiler.context.SpanAsyncStateListener;
import com.navercorp.pinpoint.profiler.context.SpanEvent;
import com.navercorp.pinpoint.profiler.context.SpanFactory;
import com.navercorp.pinpoint.profiler.context.active.ActiveTraceHandle;
import com.navercorp.pinpoint.profiler.context.active.ActiveTraceRepository;
import com.navercorp.pinpoint.profiler.context.id.ListenableAsyncState;
import com.navercorp.pinpoint.profiler.context.id.TraceRoot;
import com.navercorp.pinpoint.profiler.context.id.TraceRootFactory;
import com.navercorp.pinpoint.profiler.context.recorder.RecorderFactory;
import com.navercorp.pinpoint.profiler.context.recorder.WrappedSpanEventRecorder;
import com.navercorp.pinpoint.profiler.context.storage.Storage;
import com.navercorp.pinpoint.profiler.context.storage.StorageFactory;
import java.util.Objects;

public class DefaultBaseTraceFactory
implements BaseTraceFactory {
    private final CallStackFactory<SpanEvent> callStackFactory;
    private final StorageFactory storageFactory;
    private final TraceSampler traceSampler;
    private final SpanFactory spanFactory;
    private final RecorderFactory recorderFactory;
    private final TraceRootFactory traceRootFactory;
    private final ActiveTraceRepository activeTraceRepository;

    public DefaultBaseTraceFactory(TraceRootFactory traceRootFactory, CallStackFactory<SpanEvent> callStackFactory, StorageFactory storageFactory, TraceSampler traceSampler, SpanFactory spanFactory, RecorderFactory recorderFactory, ActiveTraceRepository activeTraceRepository) {
        this.traceRootFactory = Objects.requireNonNull(traceRootFactory, "traceRootFactory");
        this.callStackFactory = Objects.requireNonNull(callStackFactory, "callStackFactory");
        this.storageFactory = Objects.requireNonNull(storageFactory, "storageFactory");
        this.traceSampler = Objects.requireNonNull(traceSampler, "traceSampler");
        this.spanFactory = Objects.requireNonNull(spanFactory, "spanFactory");
        this.recorderFactory = Objects.requireNonNull(recorderFactory, "recorderFactory");
        this.activeTraceRepository = Objects.requireNonNull(activeTraceRepository, "activeTraceRepository");
    }

    @Override
    public Trace continueTraceObject(TraceId traceId) {
        TraceSampler.State state = this.traceSampler.isContinueSampled();
        if (state.isSampled()) {
            TraceRoot traceRoot = this.traceRootFactory.continueTraceRoot(traceId, state.nextId());
            Span span = this.spanFactory.newSpan(traceRoot);
            DefaultSpanChunkFactory spanChunkFactory = new DefaultSpanChunkFactory(traceRoot);
            Storage storage = this.storageFactory.createStorage(spanChunkFactory);
            CallStack<SpanEvent> callStack = this.callStackFactory.newCallStack();
            boolean samplingEnable = true;
            SpanRecorder spanRecorder = this.recorderFactory.newSpanRecorder(span, traceId.isRoot(), true);
            WrappedSpanEventRecorder wrappedSpanEventRecorder = this.recorderFactory.newWrappedSpanEventRecorder(traceRoot);
            ActiveTraceHandle handle = this.registerActiveTrace(traceRoot);
            DefaultTrace trace = new DefaultTrace(span, callStack, storage, true, spanRecorder, wrappedSpanEventRecorder, handle);
            return trace;
        }
        return this.newDisableTrace(state.nextId());
    }

    private ActiveTraceHandle registerActiveTrace(TraceRoot traceRoot) {
        return this.activeTraceRepository.register(traceRoot);
    }

    private ActiveTraceHandle registerActiveTrace(long localTransactionId, long startTime, long threadId) {
        return this.activeTraceRepository.register(localTransactionId, startTime, threadId);
    }

    @Override
    public Trace newTraceObject() {
        TraceSampler.State state = this.traceSampler.isNewSampled();
        boolean sampling = state.isSampled();
        if (sampling) {
            TraceRoot traceRoot = this.traceRootFactory.newTraceRoot(state.nextId());
            Span span = this.spanFactory.newSpan(traceRoot);
            DefaultSpanChunkFactory spanChunkFactory = new DefaultSpanChunkFactory(traceRoot);
            Storage storage = this.storageFactory.createStorage(spanChunkFactory);
            CallStack<SpanEvent> callStack = this.callStackFactory.newCallStack();
            TraceId traceId = traceRoot.getTraceId();
            SpanRecorder spanRecorder = this.recorderFactory.newSpanRecorder(span, traceId.isRoot(), sampling);
            WrappedSpanEventRecorder wrappedSpanEventRecorder = this.recorderFactory.newWrappedSpanEventRecorder(traceRoot);
            ActiveTraceHandle handle = this.registerActiveTrace(traceRoot);
            DefaultTrace trace = new DefaultTrace(span, callStack, storage, sampling, spanRecorder, wrappedSpanEventRecorder, handle);
            return trace;
        }
        return this.newDisableTrace(state.nextId());
    }

    @Override
    public Trace continueAsyncContextTraceObject(TraceRoot traceRoot, LocalAsyncId localAsyncId, boolean canSampled) {
        if (canSampled) {
            AsyncSpanChunkFactory spanChunkFactory = new AsyncSpanChunkFactory(traceRoot, localAsyncId);
            Storage storage = this.storageFactory.createStorage(spanChunkFactory);
            CallStack<SpanEvent> callStack = this.callStackFactory.newCallStack();
            boolean samplingEnable = true;
            SpanRecorder spanRecorder = this.recorderFactory.newTraceRootSpanRecorder(traceRoot, true);
            WrappedSpanEventRecorder wrappedSpanEventRecorder = this.recorderFactory.newWrappedSpanEventRecorder(traceRoot);
            AsyncChildTrace asyncTrace = new AsyncChildTrace(traceRoot, callStack, storage, true, spanRecorder, wrappedSpanEventRecorder, localAsyncId);
            return asyncTrace;
        }
        return new DisableAsyncChildTrace(traceRoot, localAsyncId);
    }

    @Override
    @InterfaceAudience.LimitedPrivate(value={"vert.x"})
    public Trace continueAsyncTraceObject(TraceId traceId) {
        TraceSampler.State state = this.traceSampler.isContinueSampled();
        boolean sampling = state.isSampled();
        if (sampling) {
            TraceRoot traceRoot = this.traceRootFactory.continueTraceRoot(traceId, state.nextId());
            Span span = this.spanFactory.newSpan(traceRoot);
            DefaultSpanChunkFactory spanChunkFactory = new DefaultSpanChunkFactory(traceRoot);
            Storage storage = this.storageFactory.createStorage(spanChunkFactory);
            CallStack<SpanEvent> callStack = this.callStackFactory.newCallStack();
            ActiveTraceHandle handle = this.registerActiveTrace(traceRoot);
            SpanAsyncStateListener asyncStateListener = new SpanAsyncStateListener(span, this.storageFactory);
            ListenableAsyncState asyncState = new ListenableAsyncState(asyncStateListener, handle);
            SpanRecorder spanRecorder = this.recorderFactory.newSpanRecorder(span, traceId.isRoot(), sampling);
            WrappedSpanEventRecorder wrappedSpanEventRecorder = this.recorderFactory.newWrappedSpanEventRecorder(traceRoot, asyncState);
            DefaultTrace trace = new DefaultTrace(span, callStack, storage, sampling, spanRecorder, wrappedSpanEventRecorder, ActiveTraceHandle.EMPTY_HANDLE);
            AsyncTrace asyncTrace = new AsyncTrace(traceRoot, trace, asyncState);
            return asyncTrace;
        }
        return this.newDisableTrace(state.nextId());
    }

    @Override
    @InterfaceAudience.LimitedPrivate(value={"vert.x"})
    public Trace newAsyncTraceObject() {
        TraceSampler.State state = this.traceSampler.isNewSampled();
        boolean sampling = state.isSampled();
        if (sampling) {
            TraceRoot traceRoot = this.traceRootFactory.newTraceRoot(state.nextId());
            Span span = this.spanFactory.newSpan(traceRoot);
            DefaultSpanChunkFactory spanChunkFactory = new DefaultSpanChunkFactory(traceRoot);
            Storage storage = this.storageFactory.createStorage(spanChunkFactory);
            CallStack<SpanEvent> callStack = this.callStackFactory.newCallStack();
            ActiveTraceHandle handle = this.registerActiveTrace(traceRoot);
            SpanAsyncStateListener asyncStateListener = new SpanAsyncStateListener(span, this.storageFactory);
            ListenableAsyncState asyncState = new ListenableAsyncState(asyncStateListener, handle);
            TraceId traceId = traceRoot.getTraceId();
            SpanRecorder spanRecorder = this.recorderFactory.newSpanRecorder(span, traceId.isRoot(), sampling);
            WrappedSpanEventRecorder wrappedSpanEventRecorder = this.recorderFactory.newWrappedSpanEventRecorder(traceRoot, asyncState);
            DefaultTrace trace = new DefaultTrace(span, callStack, storage, sampling, spanRecorder, wrappedSpanEventRecorder, ActiveTraceHandle.EMPTY_HANDLE);
            AsyncTrace asyncTrace = new AsyncTrace(traceRoot, trace, asyncState);
            return asyncTrace;
        }
        return this.newDisableTrace(state.nextId());
    }

    @Override
    public Trace disableSampling() {
        TraceSampler.State state = this.traceSampler.getContinueDisableState();
        long nextContinuedDisabledId = state.nextId();
        return this.newDisableTrace(nextContinuedDisabledId);
    }

    private Trace newDisableTrace(long nextDisabledId) {
        long traceStartTime = System.currentTimeMillis();
        long threadId = Thread.currentThread().getId();
        ActiveTraceHandle activeTraceHandle = this.registerActiveTrace(nextDisabledId, traceStartTime, threadId);
        DisableTrace disableTrace = new DisableTrace(nextDisabledId, traceStartTime, activeTraceHandle);
        return disableTrace;
    }
}

