/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.utils;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;

public abstract class SystemUtils {
    public static final String OS_NAME = System.getProperty("os.name");
    private static boolean isLinuxPlatform = false;
    private static boolean isWindowsPlatform = false;

    private SystemUtils() {
    }

    public static boolean isLinuxPlatform() {
        return isLinuxPlatform;
    }

    public static boolean isWindowsPlatform() {
        return isWindowsPlatform;
    }

    public static String getProcessId() {
        try {
            Class<?> managementFactoryClass = Class.forName("java.lang.management.ManagementFactory");
            Method getRuntimeMXBean = managementFactoryClass.getDeclaredMethod("getRuntimeMXBean", new Class[0]);
            Class<?> runtimeMXBeanClass = Class.forName("java.lang.management.RuntimeMXBean");
            Method getName = runtimeMXBeanClass.getDeclaredMethod("getName", new Class[0]);
            Object runtimeMXBean = getRuntimeMXBean.invoke(null, new Object[0]);
            String name = (String)getName.invoke(runtimeMXBean, new Object[0]);
            return name.split("@")[0];
        }
        catch (Exception ex) {
            try {
                return new File("/proc/self").getCanonicalFile().getName();
            }
            catch (IOException iOException) {
                return "-1";
            }
        }
    }

    static {
        if (OS_NAME != null && OS_NAME.toLowerCase().contains("linux")) {
            isLinuxPlatform = true;
        }
        if (OS_NAME != null && OS_NAME.toLowerCase().contains("windows")) {
            isWindowsPlatform = true;
        }
    }
}

