/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util;

import io.pravega.common.util.SortedIndex;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class RedBlackTreeIndex<V extends SortedIndex.IndexEntry>
implements SortedIndex<V> {
    private final TreeMap<Long, V> map = new TreeMap(Long::compare);

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public V put(V item) {
        return (V)((SortedIndex.IndexEntry)this.map.put(item.key(), item));
    }

    @Override
    public V remove(long key) {
        return (V)((SortedIndex.IndexEntry)this.map.remove(key));
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public V get(long key) {
        return (V)((SortedIndex.IndexEntry)this.map.get(key));
    }

    @Override
    public V getCeiling(long key) {
        return this.getValue(this.map.ceilingEntry(key));
    }

    @Override
    public V getFloor(long key) {
        return this.getValue(this.map.floorEntry(key));
    }

    @Override
    public V getFirst() {
        return this.getValue(this.map.firstEntry());
    }

    @Override
    public V getLast() {
        return this.getValue(this.map.lastEntry());
    }

    @Override
    public void forEach(Consumer<V> consumer) {
        this.map.values().forEach(consumer);
    }

    private V getValue(Map.Entry<Long, V> e) {
        return (V)(e == null ? null : (SortedIndex.IndexEntry)e.getValue());
    }
}

