/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.util;

import com.navercorp.pinpoint.common.util.TraceHeader;

public class StringTraceHeaderParser {
    public static final char DELIMITER_STRING = ':';
    public static final int ID_INDEX = 36;

    public String createHeader(String uuid, int spanId, int parentSpanId, int sampling, short flag) {
        StringBuilder sb = new StringBuilder(128);
        sb.append(uuid);
        sb.append(':');
        sb.append(spanId);
        sb.append(':');
        sb.append(parentSpanId);
        sb.append(':');
        sb.append(sampling);
        sb.append(':');
        sb.append(flag);
        return sb.toString();
    }

    public TraceHeader parseHeader(String traceHeader) {
        if (traceHeader == null) {
            return null;
        }
        char c = traceHeader.charAt(36);
        if (c != ':') {
            return null;
        }
        String id = traceHeader.substring(0, 36);
        int spanIdStartIndex = 37;
        int spanIdEndIndex = traceHeader.indexOf(58, spanIdStartIndex);
        String spanId = traceHeader.substring(spanIdStartIndex, spanIdEndIndex);
        int parentSpanIdStartIndex = spanIdEndIndex + 1;
        int parentSpanIdEndIndex = traceHeader.indexOf(58, parentSpanIdStartIndex);
        String parentSpanId = traceHeader.substring(parentSpanIdStartIndex, parentSpanIdEndIndex);
        int samplingStartIndex = parentSpanIdEndIndex + 1;
        int samplingEndIndex = traceHeader.indexOf(58, samplingStartIndex);
        if (samplingEndIndex == -1) {
            return new TraceHeader(id, spanId, parentSpanId, "", "");
        }
        String sampling = traceHeader.substring(samplingStartIndex, samplingEndIndex);
        int flagStartIndex = samplingEndIndex + 1;
        if (flagStartIndex == -1) {
            return new TraceHeader(id, spanId, parentSpanId, sampling, "");
        }
        int flagEndIndex = traceHeader.indexOf(58, flagStartIndex);
        if (flagEndIndex == -1) {
            String flag = traceHeader.substring(flagStartIndex);
            return new TraceHeader(id, spanId, parentSpanId, sampling, flag);
        }
        String flag = traceHeader.substring(flagStartIndex, flagEndIndex);
        return new TraceHeader(id, spanId, parentSpanId, sampling, flag);
    }
}

