/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.util;

public final class MathUtils {
    private MathUtils() {
    }

    public static int fastAbs(int value) {
        return value & Integer.MAX_VALUE;
    }

    public static long roundToNearestMultipleOf(long num, long multipleOf) {
        if (num < 0L) {
            throw new IllegalArgumentException("num cannot be negative");
        }
        if (multipleOf < 1L) {
            throw new IllegalArgumentException("cannot round to nearest multiple of values less than 1");
        }
        if (num < multipleOf) {
            return multipleOf;
        }
        if ((double)(num % multipleOf) >= (double)multipleOf / 2.0) {
            return num + multipleOf - num % multipleOf;
        }
        return num - num % multipleOf;
    }

    public static long floorMod(long a, long b) {
        if (b == 0L) {
            throw new IllegalArgumentException("denominator must be different from 0");
        }
        long m = a % b;
        if ((a ^ b) >= 0L || m == 0L) {
            return m;
        }
        return b + m;
    }

    public static int floorMod(int a, int b) {
        if (b == 0) {
            throw new IllegalArgumentException("denominator must be different from 0");
        }
        int m = a % b;
        if ((a ^ b) >= 0 || m == 0) {
            return m;
        }
        return b + m;
    }
}

