/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.trace;

import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.common.trace.ServiceTypeLocator;
import java.util.List;

public class ServiceTypeProvider {
    private static final ServiceTypeLocator UNREGISTERED;
    private static ServiceTypeLocator registry;

    private ServiceTypeProvider() {
        throw new AssertionError();
    }

    public static ServiceType getByCode(int serviceTypeCode) {
        ServiceType serviceType = registry.findServiceType((short)serviceTypeCode);
        if (ServiceType.UNDEFINED == serviceType) {
            throw new IllegalStateException("Unknown ServiceType code: " + serviceTypeCode);
        }
        return serviceType;
    }

    public static ServiceType getByName(String serviceTypeName) {
        ServiceType serviceType = registry.findServiceTypeByName(serviceTypeName);
        if (ServiceType.UNDEFINED == serviceType) {
            throw new IllegalStateException("Unknown ServiceType name: " + serviceTypeName);
        }
        return serviceType;
    }

    static {
        registry = UNREGISTERED = new ServiceTypeLocator(){

            @Override
            public ServiceType findServiceType(short code) {
                throw new IllegalStateException("ServiceTypeRegistry not registered");
            }

            @Override
            public ServiceType findServiceTypeByName(String name) {
                throw new IllegalStateException("ServiceTypeRegistry not registered");
            }

            @Override
            public List<ServiceType> findDesc(String name) {
                throw new IllegalStateException("ServiceTypeRegistry not registered");
            }
        };
    }
}

