/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.controller.event;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.shared.controller.event.ControllerEvent;
import io.pravega.shared.controller.event.RequestProcessor;
import io.pravega.shared.controller.event.StreamRequestProcessor;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;

public class TruncateStreamEvent
implements ControllerEvent {
    private static final long serialVersionUID = 1L;
    private final String scope;
    private final String stream;
    private final long requestId;

    @Override
    public String getKey() {
        return String.format("%s/%s", this.scope, this.stream);
    }

    @Override
    public CompletableFuture<Void> process(RequestProcessor processor) {
        return ((StreamRequestProcessor)processor).processTruncateStream(this);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static TruncateStreamEventBuilder builder() {
        return new TruncateStreamEventBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getScope() {
        return this.scope;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getStream() {
        return this.stream;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getRequestId() {
        return this.requestId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TruncateStreamEvent)) {
            return false;
        }
        TruncateStreamEvent other = (TruncateStreamEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        String this$stream = this.getStream();
        String other$stream = other.getStream();
        if (this$stream == null ? other$stream != null : !this$stream.equals(other$stream)) {
            return false;
        }
        return this.getRequestId() == other.getRequestId();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TruncateStreamEvent;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        String $stream = this.getStream();
        result = result * 59 + ($stream == null ? 43 : $stream.hashCode());
        long $requestId = this.getRequestId();
        result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "TruncateStreamEvent(scope=" + this.getScope() + ", stream=" + this.getStream() + ", requestId=" + this.getRequestId() + ")";
    }

    @ConstructorProperties(value={"scope", "stream", "requestId"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public TruncateStreamEvent(String scope, String stream, long requestId) {
        this.scope = scope;
        this.stream = stream;
        this.requestId = requestId;
    }

    public static class Serializer
    extends VersionedSerializer.WithBuilder<TruncateStreamEvent, TruncateStreamEventBuilder> {
        protected TruncateStreamEventBuilder newBuilder() {
            return TruncateStreamEvent.builder();
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void write00(TruncateStreamEvent e, RevisionDataOutput target) throws IOException {
            target.writeUTF(e.scope);
            target.writeUTF(e.stream);
            target.writeLong(e.requestId);
        }

        private void read00(RevisionDataInput source, TruncateStreamEventBuilder b) throws IOException {
            b.scope(source.readUTF());
            b.stream(source.readUTF());
            b.requestId(source.readLong());
        }
    }

    private static class TruncateStreamEventBuilder
    implements ObjectBuilder<TruncateStreamEvent> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String scope;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String stream;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long requestId;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        TruncateStreamEventBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TruncateStreamEventBuilder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TruncateStreamEventBuilder stream(String stream) {
            this.stream = stream;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TruncateStreamEventBuilder requestId(long requestId) {
            this.requestId = requestId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TruncateStreamEvent build() {
            return new TruncateStreamEvent(this.scope, this.stream, this.requestId);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "TruncateStreamEvent.TruncateStreamEventBuilder(scope=" + this.scope + ", stream=" + this.stream + ", requestId=" + this.requestId + ")";
        }
    }
}

