/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.controller.event;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.shared.controller.event.ControllerEvent;
import io.pravega.shared.controller.event.RequestProcessor;
import io.pravega.shared.controller.event.StreamRequestProcessor;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;

public class DeleteScopeEvent
implements ControllerEvent {
    private static final long serialVersionUID = 1L;
    private final String scope;
    private final long requestId;
    private final UUID scopeId;

    @Override
    public String getKey() {
        return this.scope;
    }

    @Override
    public CompletableFuture<Void> process(RequestProcessor processor) {
        return ((StreamRequestProcessor)processor).processDeleteScopeRecursive(this);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static DeleteScopeEventBuilder builder() {
        return new DeleteScopeEventBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getScope() {
        return this.scope;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getRequestId() {
        return this.requestId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public UUID getScopeId() {
        return this.scopeId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteScopeEvent)) {
            return false;
        }
        DeleteScopeEvent other = (DeleteScopeEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        if (this.getRequestId() != other.getRequestId()) {
            return false;
        }
        UUID this$scopeId = this.getScopeId();
        UUID other$scopeId = other.getScopeId();
        return !(this$scopeId == null ? other$scopeId != null : !((Object)this$scopeId).equals(other$scopeId));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DeleteScopeEvent;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        long $requestId = this.getRequestId();
        result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
        UUID $scopeId = this.getScopeId();
        result = result * 59 + ($scopeId == null ? 43 : ((Object)$scopeId).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "DeleteScopeEvent(scope=" + this.getScope() + ", requestId=" + this.getRequestId() + ", scopeId=" + this.getScopeId() + ")";
    }

    @ConstructorProperties(value={"scope", "requestId", "scopeId"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DeleteScopeEvent(String scope, long requestId, UUID scopeId) {
        this.scope = scope;
        this.requestId = requestId;
        this.scopeId = scopeId;
    }

    public static class Serializer
    extends VersionedSerializer.WithBuilder<DeleteScopeEvent, DeleteScopeEventBuilder> {
        protected DeleteScopeEventBuilder newBuilder() {
            return DeleteScopeEvent.builder();
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void write00(DeleteScopeEvent e, RevisionDataOutput target) throws IOException {
            target.writeUTF(e.scope);
            target.writeLong(e.requestId);
            target.writeUUID(e.scopeId);
        }

        private void read00(RevisionDataInput source, DeleteScopeEventBuilder b) throws IOException {
            b.scope(source.readUTF());
            b.requestId(source.readLong());
            b.scopeId(source.readUUID());
        }
    }

    private static class DeleteScopeEventBuilder
    implements ObjectBuilder<DeleteScopeEvent> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String scope;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long requestId;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private UUID scopeId;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        DeleteScopeEventBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DeleteScopeEventBuilder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DeleteScopeEventBuilder requestId(long requestId) {
            this.requestId = requestId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DeleteScopeEventBuilder scopeId(UUID scopeId) {
            this.scopeId = scopeId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DeleteScopeEvent build() {
            return new DeleteScopeEvent(this.scope, this.requestId, this.scopeId);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "DeleteScopeEvent.DeleteScopeEventBuilder(scope=" + this.scope + ", requestId=" + this.requestId + ", scopeId=" + this.scopeId + ")";
        }
    }
}

