/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.util;

import java.util.Collections;
import java.util.List;

public final class ListUtils {
    private ListUtils() {
    }

    public static <V> boolean addIfValueNotNull(List<V> list, V value) {
        if (value == null) {
            return false;
        }
        return list.add(value);
    }

    public static <V> boolean addAllIfAllValuesNotNull(List<V> list, V[] values) {
        if (values == null) {
            return false;
        }
        for (V value : values) {
            if (value != null) continue;
            return false;
        }
        return Collections.addAll(list, values);
    }

    public static <V> void addAllExceptNullValue(List<V> list, V[] values) {
        if (values == null) {
            return;
        }
        for (V value : values) {
            ListUtils.addIfValueNotNull(list, value);
        }
    }

    @Deprecated
    public static <V> V getFirst(List<V> list) {
        return ListUtils.getFirst(list, null);
    }

    @Deprecated
    public static <V> V getFirst(List<V> list, V defaultValue) {
        if (list == null) {
            return defaultValue;
        }
        int size = list.size();
        if (size > 0) {
            return list.get(0);
        }
        return defaultValue;
    }

    @Deprecated
    public static <V> boolean isFirst(List<V> list, V object) {
        V first = ListUtils.getFirst(list);
        if (first == null) {
            return object == null;
        }
        return first.equals(object);
    }

    @Deprecated
    public static <V> V get(List<V> list, int index, V defaultValue) {
        try {
            return list.get(index);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    @Deprecated
    public static <V> V getLast(List<V> list) {
        return ListUtils.getLast(list, null);
    }

    @Deprecated
    public static <V> V getLast(List<V> list, V defaultValue) {
        if (list == null) {
            return defaultValue;
        }
        int size = list.size();
        if (size > 0) {
            return list.get(size - 1);
        }
        return defaultValue;
    }

    public static <V> boolean isLast(List<V> list, V object) {
        V last = ListUtils.getLast(list);
        if (last == null) {
            return object == null;
        }
        return last.equals(object);
    }
}

