/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc;

import com.navercorp.pinpoint.rpc.FailureEventHandler;
import com.navercorp.pinpoint.rpc.Future;
import com.navercorp.pinpoint.rpc.FutureListener;
import com.navercorp.pinpoint.rpc.PinpointSocketException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.TimerTask;

public class DefaultFuture<T>
implements TimerTask,
Future<T> {
    private static final Logger logger = LogManager.getLogger(DefaultFuture.class);
    private final long timeoutMillis;
    private int waiters = 0;
    private boolean ready = false;
    private T result;
    private Throwable cause;
    private Timeout timeout;
    private FailureEventHandler failureEventHandler;
    private FutureListener<T> listener;

    public DefaultFuture() {
        this(3000L);
    }

    public DefaultFuture(long timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    @Override
    public synchronized T getResult() {
        if (this.cause != null) {
            throw new PinpointSocketException(this.cause);
        }
        return this.result;
    }

    @Override
    public synchronized Throwable getCause() {
        return this.cause;
    }

    @Override
    public synchronized boolean isReady() {
        return this.ready;
    }

    @Override
    public synchronized boolean isSuccess() {
        return this.ready && this.cause == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setResult(T message) {
        DefaultFuture defaultFuture = this;
        synchronized (defaultFuture) {
            if (this.ready) {
                return false;
            }
            this.ready = true;
            this.result = message;
            if (this.waiters > 0) {
                this.notifyAll();
            }
        }
        this.cancelTimeout();
        this.notifyListener();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setFailure(Throwable cause) {
        DefaultFuture defaultFuture = this;
        synchronized (defaultFuture) {
            if (this.ready) {
                return false;
            }
            this.ready = true;
            this.cause = cause;
            if (this.waiters > 0) {
                this.notifyAll();
            }
        }
        this.cancelTimeout();
        this.notifyFailureHandle();
        this.notifyListener();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fireTimeout() {
        DefaultFuture defaultFuture = this;
        synchronized (defaultFuture) {
            if (this.ready) {
                return false;
            }
            this.ready = true;
            this.cause = new PinpointSocketException("timeout");
            if (this.waiters > 0) {
                this.notifyAll();
            }
        }
        this.notifyFailureHandle();
        this.notifyListener();
        return true;
    }

    private void cancelTimeout() {
        Timeout timeout = this.timeout;
        if (timeout != null) {
            timeout.cancel();
            this.timeout = null;
        }
    }

    private void notifyListener() {
        FutureListener<T> listener = this.listener;
        if (listener != null) {
            this.fireOnComplete(listener);
            this.listener = null;
        }
    }

    protected void notifyFailureHandle() {
        FailureEventHandler failureEventHandler = this.failureEventHandler;
        if (failureEventHandler != null) {
            failureEventHandler.fireFailure();
            this.failureEventHandler = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setListener(FutureListener<T> listener) {
        Objects.requireNonNull(listener, "listener");
        boolean alreadyReady = false;
        DefaultFuture defaultFuture = this;
        synchronized (defaultFuture) {
            if (this.ready) {
                alreadyReady = true;
            } else {
                this.listener = listener;
            }
        }
        if (alreadyReady) {
            this.fireOnComplete(listener);
        }
        return !alreadyReady;
    }

    private boolean fireOnComplete(FutureListener<T> listener) {
        try {
            listener.onComplete(this);
            return true;
        }
        catch (Throwable th) {
            logger.warn("FutureListener.onComplete() fail Caused:{}", (Object)th.getMessage(), (Object)th);
            return false;
        }
    }

    @Override
    public boolean await(long timeoutMillis) {
        return this.await0(timeoutMillis);
    }

    @Override
    public boolean await() {
        return this.await0(this.timeoutMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private boolean await0(long timeoutMillis) {
        boolean interrupted;
        block12: {
            if (timeoutMillis < 0L) {
                throw new IllegalArgumentException("timeoutMillis must not be negative :" + timeoutMillis);
            }
            interrupted = false;
            try {
                DefaultFuture defaultFuture = this;
                // MONITORENTER : defaultFuture
                if (!this.ready) break block12;
                boolean bl = true;
                // MONITOREXIT : defaultFuture
                if (!interrupted) return bl;
                Thread.currentThread().interrupt();
                return bl;
            }
            catch (Throwable throwable) {
                if (!interrupted) throw throwable;
                Thread.currentThread().interrupt();
                throw throwable;
            }
        }
        try {
            ++this.waiters;
            this.wait(timeoutMillis);
        }
        catch (InterruptedException e) {
            interrupted = true;
        }
        finally {
            --this.waiters;
        }
        boolean bl = this.ready;
        // MONITOREXIT : defaultFuture
        if (!interrupted) return bl;
        Thread.currentThread().interrupt();
        return bl;
    }

    public void run(Timeout timeout) throws Exception {
        if (timeout.isCancelled()) {
            return;
        }
        this.fireTimeout();
    }

    public void setTimeout(Timeout timeout) {
        this.timeout = Objects.requireNonNull(timeout, "timeout");
    }

    public void setFailureEventHandler(FailureEventHandler failureEventHandler) {
        this.failureEventHandler = Objects.requireNonNull(failureEventHandler, "failureEventHandler");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DefaultFuture");
        sb.append("{ready=").append(this.ready);
        sb.append(", result=").append(this.result);
        sb.append(", cause=").append(this.cause);
        sb.append('}');
        return sb.toString();
    }
}

