/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client.session.retry;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.eventmesh.common.EventMeshThreadFactory;
import org.apache.eventmesh.common.protocol.SubscriptionType;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.core.protocol.RetryContext;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.push.DownStreamMsgContext;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshTcpRetryer {
    private static final Logger log = LoggerFactory.getLogger(EventMeshTcpRetryer.class);
    private EventMeshTCPServer eventMeshTCPServer;
    private DelayQueue<RetryContext> retrys = new DelayQueue();
    private ThreadPoolExecutor pool = new ThreadPoolExecutor(3, 3, 60000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1000), (ThreadFactory)new EventMeshThreadFactory("eventMesh-tcp-retry", true), new ThreadPoolExecutor.AbortPolicy());
    private Thread dispatcher;

    public EventMeshTcpRetryer(EventMeshTCPServer eventMeshTCPServer) {
        this.eventMeshTCPServer = eventMeshTCPServer;
    }

    public EventMeshTCPServer getEventMeshTCPServer() {
        return this.eventMeshTCPServer;
    }

    public void setEventMeshTCPServer(EventMeshTCPServer eventMeshTCPServer) {
        this.eventMeshTCPServer = eventMeshTCPServer;
    }

    public void pushRetry(RetryContext retryContext) {
        if (this.retrys.size() >= this.eventMeshTCPServer.getEventMeshTCPConfiguration().getEventMeshTcpMsgRetryQueueSize()) {
            log.error("pushRetry fail,retrys is too much,allow max retryQueueSize:{}, retryTimes:{}, seq:{}, bizSeq:{}", new Object[]{this.eventMeshTCPServer.getEventMeshTCPConfiguration().getEventMeshTcpMsgRetryQueueSize(), retryContext.retryTimes, retryContext.seq, EventMeshUtil.getMessageBizSeq(retryContext.event)});
            return;
        }
        int maxRetryTimes = this.eventMeshTCPServer.getEventMeshTCPConfiguration().getEventMeshTcpMsgAsyncRetryTimes();
        if (retryContext instanceof DownStreamMsgContext) {
            DownStreamMsgContext downStreamMsgContext = (DownStreamMsgContext)retryContext;
            int n = maxRetryTimes = SubscriptionType.SYNC == downStreamMsgContext.getSubscriptionItem().getType() ? this.eventMeshTCPServer.getEventMeshTCPConfiguration().getEventMeshTcpMsgSyncRetryTimes() : this.eventMeshTCPServer.getEventMeshTCPConfiguration().getEventMeshTcpMsgAsyncRetryTimes();
        }
        if (retryContext.retryTimes >= maxRetryTimes) {
            log.warn("pushRetry fail,retry over maxRetryTimes:{}, retryTimes:{}, seq:{}, bizSeq:{}", new Object[]{maxRetryTimes, retryContext.retryTimes, retryContext.seq, EventMeshUtil.getMessageBizSeq(retryContext.event)});
            return;
        }
        this.retrys.offer(retryContext);
        log.info("pushRetry success,seq:{}, retryTimes:{}, bizSeq:{}", new Object[]{retryContext.seq, retryContext.retryTimes, EventMeshUtil.getMessageBizSeq(retryContext.event)});
    }

    public void init() {
        this.dispatcher = new Thread(() -> {
            try {
                RetryContext retryContext;
                while ((retryContext = (RetryContext)this.retrys.take()) != null) {
                    RetryContext retryCtx = retryContext;
                    this.pool.execute(() -> {
                        try {
                            retryCtx.retry();
                        }
                        catch (Exception e) {
                            log.error("retry-dispatcher error!", (Throwable)e);
                        }
                    });
                }
            }
            catch (Exception e) {
                log.error("retry-dispatcher error!", (Throwable)e);
            }
        }, "retry-dispatcher");
        this.dispatcher.setDaemon(true);
        log.info("EventMeshTcpRetryer inited......");
    }

    public void start() throws Exception {
        this.dispatcher.start();
        log.info("EventMeshTcpRetryer started......");
    }

    public void shutdown() {
        this.pool.shutdown();
        log.info("EventMeshTcpRetryer shutdown......");
    }

    public int getRetrySize() {
        return this.retrys.size();
    }

    public void printRetryThreadPoolState() {
    }
}

