/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.producer;

import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.RequestReplyCallback;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.runtime.configuration.EventMeshHTTPConfiguration;
import org.apache.eventmesh.runtime.core.consumergroup.ProducerGroupConf;
import org.apache.eventmesh.runtime.core.plugin.MQProducerWrapper;
import org.apache.eventmesh.runtime.core.protocol.http.producer.SendMessageContext;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshProducer {
    private static final Logger log = LoggerFactory.getLogger(EventMeshProducer.class);
    protected AtomicBoolean started = new AtomicBoolean(Boolean.FALSE);
    protected AtomicBoolean inited = new AtomicBoolean(Boolean.FALSE);
    protected ProducerGroupConf producerGroupConfig;
    protected EventMeshHTTPConfiguration eventMeshHttpConfiguration;
    protected MQProducerWrapper mqProducerWrapper;

    public AtomicBoolean getInited() {
        return this.inited;
    }

    public AtomicBoolean getStarted() {
        return this.started;
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public void send(SendMessageContext sendMsgContext, SendCallback sendCallback) throws Exception {
        this.mqProducerWrapper.send(sendMsgContext.getEvent(), sendCallback);
    }

    public void request(SendMessageContext sendMsgContext, RequestReplyCallback rrCallback, long timeout) throws Exception {
        this.mqProducerWrapper.request(sendMsgContext.getEvent(), rrCallback, timeout);
    }

    public boolean reply(SendMessageContext sendMsgContext, SendCallback sendCallback) throws Exception {
        this.mqProducerWrapper.reply(sendMsgContext.getEvent(), sendCallback);
        return true;
    }

    public MQProducerWrapper getMqProducerWrapper() {
        return this.mqProducerWrapper;
    }

    public void init(EventMeshHTTPConfiguration eventMeshHttpConfiguration, ProducerGroupConf producerGroupConfig) throws Exception {
        if (!this.inited.compareAndSet(false, true)) {
            return;
        }
        this.producerGroupConfig = producerGroupConfig;
        this.eventMeshHttpConfiguration = eventMeshHttpConfiguration;
        Properties keyValue = new Properties();
        keyValue.put("producerGroup", producerGroupConfig.getGroupName());
        keyValue.put("instanceName", EventMeshUtil.buildMeshClientID(producerGroupConfig.getGroupName(), eventMeshHttpConfiguration.getEventMeshCluster()));
        if (StringUtils.isNotBlank((CharSequence)producerGroupConfig.getToken())) {
            keyValue.put("producerToken", producerGroupConfig.getToken());
        }
        keyValue.put("eventMeshIDC", eventMeshHttpConfiguration.getEventMeshIDC());
        this.mqProducerWrapper = new MQProducerWrapper(eventMeshHttpConfiguration.getEventMeshStoragePluginType());
        this.mqProducerWrapper.init(keyValue);
        log.info("EventMeshProducer [{}] inited.............", (Object)producerGroupConfig.getGroupName());
    }

    public void start() throws Exception {
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        this.mqProducerWrapper.start();
        log.info("EventMeshProducer [{}] started.............", (Object)this.producerGroupConfig.getGroupName());
    }

    public void shutdown() throws Exception {
        if (!this.inited.compareAndSet(true, false)) {
            return;
        }
        if (!this.started.compareAndSet(true, false)) {
            return;
        }
        this.mqProducerWrapper.shutdown();
        log.info("EventMeshProducer [{}] shutdown.............", (Object)this.producerGroupConfig.getGroupName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("eventMeshProducer={").append("inited=").append(this.inited.get()).append(",").append("started=").append(this.started.get()).append(",").append("producerGroupConfig=").append(this.producerGroupConfig).append("}");
        return sb.toString();
    }
}

