/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.grpc.retry;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.eventmesh.common.EventMeshThreadFactory;
import org.apache.eventmesh.runtime.boot.EventMeshGrpcServer;
import org.apache.eventmesh.runtime.configuration.EventMeshGrpcConfiguration;
import org.apache.eventmesh.runtime.core.protocol.DelayRetryable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcRetryer {
    private static final Logger log = LoggerFactory.getLogger(GrpcRetryer.class);
    private final EventMeshGrpcConfiguration grpcConfiguration;
    private final DelayQueue<DelayRetryable> failed = new DelayQueue();
    private ThreadPoolExecutor pool;
    private Thread dispatcher;

    public GrpcRetryer(EventMeshGrpcServer eventMeshGrpcServer) {
        this.grpcConfiguration = eventMeshGrpcServer.getEventMeshGrpcConfiguration();
    }

    public void pushRetry(DelayRetryable delayRetryable) {
        if (this.failed.size() >= this.grpcConfiguration.getEventMeshServerRetryBlockQueueSize()) {
            log.error("[RETRY-QUEUE] is full!");
            return;
        }
        this.failed.offer(delayRetryable);
    }

    public void init() {
        this.pool = new ThreadPoolExecutor(this.grpcConfiguration.getEventMeshServerRetryThreadNum(), this.grpcConfiguration.getEventMeshServerRetryThreadNum(), 60000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(this.grpcConfiguration.getEventMeshServerRetryBlockQueueSize()), (ThreadFactory)new EventMeshThreadFactory("grpc-retry", true, Integer.valueOf(5)), new ThreadPoolExecutor.AbortPolicy());
        this.dispatcher = new Thread(() -> {
            try {
                DelayRetryable retryObj = null;
                while (!Thread.currentThread().isInterrupted() && (retryObj = (DelayRetryable)this.failed.take()) != null) {
                    DelayRetryable delayRetryable = retryObj;
                    this.pool.execute(() -> {
                        try {
                            delayRetryable.retry();
                            if (log.isDebugEnabled()) {
                                log.debug("retryObj : {}", (Object)delayRetryable);
                            }
                        }
                        catch (Exception e) {
                            log.error("grpc-retry-dispatcher error!", (Throwable)e);
                        }
                    });
                }
            }
            catch (Exception e) {
                log.error("grpc-retry-dispatcher error!", (Throwable)e);
            }
        }, "grpc-retry-dispatcher");
        this.dispatcher.setDaemon(true);
        log.info("GrpcRetryer inited......");
    }

    public int size() {
        return this.failed.size();
    }

    public void shutdown() {
        this.dispatcher.interrupt();
        this.pool.shutdown();
        log.info("GrpcRetryer shutdown......");
    }

    public void start() throws Exception {
        this.dispatcher.start();
        log.info("GrpcRetryer started......");
    }
}

