/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.acl;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.acl.AclProperties;
import org.apache.eventmesh.api.acl.AclService;
import org.apache.eventmesh.api.exception.AclException;
import org.apache.eventmesh.api.registry.bo.EventMeshAppSubTopicInfo;
import org.apache.eventmesh.api.registry.bo.EventMeshServicePubTopicInfo;
import org.apache.eventmesh.common.protocol.tcp.UserAgent;
import org.apache.eventmesh.spi.EventMeshExtensionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Acl {
    private static final Logger log = LoggerFactory.getLogger(Acl.class);
    private static final Map<String, Acl> ACL_CACHE = new HashMap<String, Acl>(16);
    private AclService aclService;
    private final AtomicBoolean inited = new AtomicBoolean(false);
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AtomicBoolean shutdown = new AtomicBoolean(false);

    private Acl() {
    }

    public static Acl getInstance(String aclPluginType) {
        return ACL_CACHE.computeIfAbsent(aclPluginType, Acl::aclBuilder);
    }

    private static Acl aclBuilder(String aclPluginType) {
        AclService aclServiceExt = (AclService)EventMeshExtensionFactory.getExtension(AclService.class, (String)aclPluginType);
        if (aclServiceExt == null) {
            log.error("can't load the aclService plugin, please check.");
            throw new RuntimeException("doesn't load the aclService plugin, please check.");
        }
        Acl acl = new Acl();
        acl.aclService = aclServiceExt;
        return acl;
    }

    public void init() throws AclException {
        if (!this.inited.compareAndSet(false, true)) {
            return;
        }
        this.aclService.init();
    }

    public void start() throws AclException {
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        this.aclService.start();
    }

    public void shutdown() throws AclException {
        this.inited.compareAndSet(true, false);
        this.started.compareAndSet(true, false);
        if (!this.shutdown.compareAndSet(false, true)) {
            return;
        }
        this.aclService.shutdown();
    }

    public void doAclCheckInTcpConnect(String remoteAddr, UserAgent userAgent, int requestCode) throws AclException {
        this.aclService.doAclCheckInConnect(Acl.buildTcpAclProperties(remoteAddr, userAgent, null, requestCode));
    }

    public void doAclCheckInTcpConnect(String remoteAddr, String token, String subsystem, Object obj) throws AclException {
        this.aclService.doAclCheckInConnect(this.buildTcpAclProperties(remoteAddr, token, subsystem, obj));
    }

    public void doAclCheckInTcpHeartbeat(String remoteAddr, UserAgent userAgent, int requestCode) throws AclException {
        this.aclService.doAclCheckInHeartbeat(Acl.buildTcpAclProperties(remoteAddr, userAgent, null, requestCode));
    }

    public void doAclCheckInTcpSend(String remoteAddr, UserAgent userAgent, String topic, int requestCode) throws AclException {
        this.aclService.doAclCheckInSend(Acl.buildTcpAclProperties(remoteAddr, userAgent, topic, requestCode));
    }

    public void doAclCheckInHttpSend(String remoteAddr, String user, String pass, String subsystem, String topic, int requestCode) throws AclException {
        this.aclService.doAclCheckInSend(this.buildHttpAclProperties(remoteAddr, user, pass, subsystem, topic, requestCode));
    }

    public void doAclCheckInHttpSend(String remoteAddr, String user, String pass, String subsystem, String topic, String requestURI) throws AclException {
        this.aclService.doAclCheckInSend(this.buildHttpAclProperties(remoteAddr, user, pass, subsystem, topic, requestURI));
    }

    public void doAclCheckInHttpSend(String remoteAddr, String token, String subsystem, String topic, String requestURI, Object obj) throws AclException {
        this.aclService.doAclCheckInSend(this.buildHttpAclProperties(remoteAddr, token, subsystem, topic, requestURI, obj));
    }

    public void doAclCheckInHttpReceive(String remoteAddr, String user, String pass, String subsystem, String topic, int requestCode) throws AclException {
        this.aclService.doAclCheckInReceive(this.buildHttpAclProperties(remoteAddr, user, pass, subsystem, topic, requestCode));
    }

    public void doAclCheckInHttpReceive(String remoteAddr, String user, String pass, String subsystem, String topic, String requestURI) throws AclException {
        this.aclService.doAclCheckInReceive(this.buildHttpAclProperties(remoteAddr, user, pass, subsystem, topic, requestURI));
    }

    public void doAclCheckInTcpReceive(String remoteAddr, String token, String subsystem, String topic, String requestURI, Object obj) throws AclException {
        this.aclService.doAclCheckInReceive(this.buildTcpAclProperties(remoteAddr, token, subsystem, topic, requestURI, obj));
    }

    public void doAclCheckInTcpReceive(String remoteAddr, UserAgent userAgent, String topic, int requestCode) throws Exception {
        this.aclService.doAclCheckInReceive(Acl.buildTcpAclProperties(remoteAddr, userAgent, topic, requestCode));
    }

    public void doAclCheckInHttpHeartbeat(String remoteAddr, String user, String pass, String subsystem, String topic, int requestCode) throws AclException {
        this.aclService.doAclCheckInHeartbeat(this.buildHttpAclProperties(remoteAddr, user, pass, subsystem, topic, requestCode));
    }

    private AclProperties buildHttpAclProperties(String remoteAddr, String user, String pass, String subsystem, String topic, int requestCode) {
        AclProperties aclProperties = new AclProperties();
        aclProperties.setClientIp(remoteAddr);
        aclProperties.setUser(user);
        aclProperties.setPwd(pass);
        aclProperties.setSubsystem(subsystem);
        aclProperties.setRequestCode(Integer.valueOf(requestCode));
        if (StringUtils.isNotBlank((CharSequence)topic)) {
            aclProperties.setTopic(topic);
        }
        return aclProperties;
    }

    private AclProperties buildHttpAclProperties(String remoteAddr, String user, String pass, String subsystem, String topic, String requestURI) {
        AclProperties aclProperties = new AclProperties();
        aclProperties.setClientIp(remoteAddr);
        aclProperties.setUser(user);
        aclProperties.setPwd(pass);
        aclProperties.setSubsystem(subsystem);
        aclProperties.setRequestURI(requestURI);
        if (StringUtils.isNotBlank((CharSequence)topic)) {
            aclProperties.setTopic(topic);
        }
        return aclProperties;
    }

    private AclProperties buildHttpAclProperties(String remoteAddr, String token, String subsystem, String topic, String requestURI, Object obj) {
        AclProperties aclProperties = new AclProperties();
        aclProperties.setClientIp(remoteAddr);
        aclProperties.setSubsystem(subsystem);
        aclProperties.setRequestURI(requestURI);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            aclProperties.setToken(token);
        }
        if (StringUtils.isNotBlank((CharSequence)topic)) {
            aclProperties.setTopic(topic);
        }
        if (obj instanceof EventMeshServicePubTopicInfo) {
            aclProperties.setExtendedField("group", (Object)((EventMeshServicePubTopicInfo)obj).getService());
            aclProperties.setExtendedField("topics", (Object)((EventMeshServicePubTopicInfo)obj).getTopics());
        }
        return aclProperties;
    }

    private static AclProperties buildTcpAclProperties(String remoteAddr, UserAgent userAgent, String topic, int requestCode) {
        AclProperties aclProperties = new AclProperties();
        aclProperties.setClientIp(remoteAddr);
        aclProperties.setUser(userAgent.getUsername());
        aclProperties.setPwd(userAgent.getPassword());
        aclProperties.setSubsystem(userAgent.getSubsystem());
        aclProperties.setRequestCode(Integer.valueOf(requestCode));
        if (StringUtils.isNotBlank((CharSequence)topic)) {
            aclProperties.setTopic(topic);
        }
        return aclProperties;
    }

    private AclProperties buildTcpAclProperties(String remoteAddr, String token, String subsystem, String topic, String requestURI, Object obj) {
        AclProperties aclProperties = new AclProperties();
        aclProperties.setClientIp(remoteAddr);
        aclProperties.setSubsystem(subsystem);
        aclProperties.setRequestURI(requestURI);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            aclProperties.setTopic(token);
        }
        if (StringUtils.isNotBlank((CharSequence)topic)) {
            aclProperties.setTopic(topic);
        }
        if (obj instanceof EventMeshAppSubTopicInfo) {
            aclProperties.setExtendedField("group", (Object)((EventMeshAppSubTopicInfo)obj).getApp());
            aclProperties.setExtendedField("topics", (Object)((EventMeshAppSubTopicInfo)obj).getTopics());
        }
        return aclProperties;
    }

    private AclProperties buildTcpAclProperties(String remoteAddr, String token, String subsystem, Object obj) {
        AclProperties aclProperties = new AclProperties();
        aclProperties.setClientIp(remoteAddr);
        aclProperties.setSubsystem(subsystem);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            aclProperties.setTopic(token);
        }
        if (obj instanceof EventMeshAppSubTopicInfo) {
            aclProperties.setExtendedField("group", (Object)((EventMeshAppSubTopicInfo)obj).getApp());
        }
        return aclProperties;
    }
}

