/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.security.auth;

import io.pravega.auth.AuthHandler;
import io.pravega.shared.security.auth.AccessOperation;
import lombok.NonNull;

public class PermissionsHelper {
    public static AuthHandler.Permissions toAuthHandlerPermissions(@NonNull AccessOperation accessOperation) {
        if (accessOperation == null) {
            throw new NullPointerException("accessOperation is marked non-null but is null");
        }
        if (accessOperation.equals((Object)AccessOperation.READ)) {
            return AuthHandler.Permissions.READ;
        }
        if (accessOperation.equals((Object)AccessOperation.WRITE) || accessOperation.equals((Object)AccessOperation.READ_WRITE)) {
            return AuthHandler.Permissions.READ_UPDATE;
        }
        if (accessOperation.equals((Object)AccessOperation.NONE)) {
            return AuthHandler.Permissions.NONE;
        }
        throw new IllegalArgumentException("Cannot translate access operation " + accessOperation.name());
    }

    public static AuthHandler.Permissions parse(AccessOperation accessOperation, AuthHandler.Permissions defaultPermissions) {
        if (accessOperation == null || accessOperation.equals((Object)AccessOperation.UNSPECIFIED)) {
            return defaultPermissions;
        }
        return PermissionsHelper.toAuthHandlerPermissions(accessOperation);
    }
}

