/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.utils;

import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.eventmesh.common.utils.SystemUtils;

public class ThreadUtils {
    private static volatile long currentPID = -1L;

    public static void randomPause(long min, long max) {
        ThreadUtils.randomPause(min, max, TimeUnit.MILLISECONDS);
    }

    public static void randomPause(long min, long max, TimeUnit timeUnit) {
        try {
            long timeout = ThreadLocalRandom.current().nextLong(min, max + 1L);
            timeUnit.sleep(timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void randomPause(long max) {
        ThreadUtils.randomPause(1L, max);
    }

    @Deprecated
    public static void sleep(long timeout) {
        ThreadUtils.sleep(timeout, TimeUnit.MILLISECONDS);
    }

    public static void sleep(long timeout, TimeUnit timeUnit) {
        try {
            ThreadUtils.sleepWithThrowException(timeout, timeUnit);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void sleepWithThrowException(long timeout, TimeUnit timeUnit) throws InterruptedException {
        if (null == timeUnit) {
            return;
        }
        timeUnit.sleep(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long getPID() {
        if (currentPID != -1L) return currentPID;
        Class<ThreadUtils> clazz = ThreadUtils.class;
        synchronized (ThreadUtils.class) {
            if (currentPID != -1L) return currentPID;
            currentPID = Long.parseLong(SystemUtils.getProcessId());
            // ** MonitorExit[var0] (shouldn't be in output)
            return currentPID;
        }
    }
}

