/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.metrics.api.model;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.eventmesh.metrics.api.model.Metric;

public class GrpcSummaryMetrics
implements Metric {
    private final AtomicLong client2EventMeshMsgNum = new AtomicLong(0L);
    private final AtomicLong eventMesh2MqMsgNum = new AtomicLong(0L);
    private final AtomicLong mq2EventMeshMsgNum = new AtomicLong(0L);
    private final AtomicLong eventMesh2ClientMsgNum = new AtomicLong(0L);
    private long client2EventMeshTPS;
    private long eventMesh2ClientTPS;
    private long eventMesh2MqTPS;
    private long mq2EventMeshTPS;
    private long retrySize;
    private long subscribeTopicNum;

    public void clearAllMessageCounter() {
        this.client2EventMeshMsgNum.set(0L);
        this.eventMesh2MqMsgNum.set(0L);
        this.mq2EventMeshMsgNum.set(0L);
        this.eventMesh2ClientMsgNum.set(0L);
    }

    public void refreshTpsMetrics(long intervalMills) {
        this.client2EventMeshTPS = 1000L * this.client2EventMeshMsgNum.get() / intervalMills;
        this.eventMesh2ClientTPS = 1000L * this.eventMesh2ClientMsgNum.get() / intervalMills;
        this.eventMesh2MqTPS = 1000L * this.eventMesh2MqMsgNum.get() / intervalMills;
        this.mq2EventMeshTPS = 1000L * this.mq2EventMeshMsgNum.get() / intervalMills;
    }

    public AtomicLong getClient2EventMeshMsgNum() {
        return this.client2EventMeshMsgNum;
    }

    public AtomicLong getEventMesh2MqMsgNum() {
        return this.eventMesh2MqMsgNum;
    }

    public AtomicLong getMq2EventMeshMsgNum() {
        return this.mq2EventMeshMsgNum;
    }

    public AtomicLong getEventMesh2ClientMsgNum() {
        return this.eventMesh2ClientMsgNum;
    }

    public long getClient2EventMeshTPS() {
        return this.client2EventMeshTPS;
    }

    public long getEventMesh2ClientTPS() {
        return this.eventMesh2ClientTPS;
    }

    public long getEventMesh2MqTPS() {
        return this.eventMesh2MqTPS;
    }

    public long getMq2EventMeshTPS() {
        return this.mq2EventMeshTPS;
    }

    public long getRetrySize() {
        return this.retrySize;
    }

    public void setRetrySize(long retrySize) {
        this.retrySize = retrySize;
    }

    public long getSubscribeTopicNum() {
        return this.subscribeTopicNum;
    }

    public void setSubscribeTopicNum(long subscribeTopicNum) {
        this.subscribeTopicNum = subscribeTopicNum;
    }
}

