/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.config.convert.converter;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.config.Config;
import org.apache.eventmesh.common.config.ConfigFiled;
import org.apache.eventmesh.common.config.ConfigInfo;
import org.apache.eventmesh.common.config.convert.ConvertInfo;
import org.apache.eventmesh.common.config.convert.ConvertValue;
import org.apache.eventmesh.common.config.convert.ConverterMap;
import org.assertj.core.util.Strings;

public class ObjectConverter
implements ConvertValue<Object> {
    private String prefix;
    private ConvertInfo convertInfo;
    private Object object;
    private char hump;
    private Class<?> clazz;
    private String reloadMethodName;

    private void init(ConfigInfo configInfo) {
        String prefix = configInfo.getPrefix();
        if (Objects.nonNull(prefix)) {
            this.prefix = prefix.endsWith(".") ? prefix : prefix + ".";
        }
        this.hump = (char)(Objects.equals(configInfo.getHump(), "rod") ? 95 : 46);
        this.clazz = this.convertInfo.getClazz();
        this.convertInfo.setHump(this.hump);
        this.reloadMethodName = configInfo.getReloadMethodName();
    }

    @Override
    public Object convert(ConvertInfo convertInfo) {
        try {
            this.convertInfo = convertInfo;
            this.object = convertInfo.getClazz().newInstance();
            this.init(convertInfo.getConfigInfo());
            this.setValue();
            Class<?> superclass = convertInfo.getClazz();
            while (!Objects.equals(superclass = superclass.getSuperclass(), Object.class) && !Objects.isNull(superclass)) {
                this.clazz = superclass;
                this.prefix = null;
                Config[] configArray = (Config[])this.clazz.getAnnotationsByType(Config.class);
                if (configArray.length != 0 && !Strings.isNullOrEmpty((String)configArray[0].prefix())) {
                    String prefix = configArray[0].prefix();
                    this.prefix = prefix.endsWith(".") ? prefix : prefix + ".";
                    this.hump = (char)(Objects.equals(configArray[0].hump(), "rod") ? 95 : 46);
                    this.convertInfo.setHump(this.hump);
                    this.reloadMethodName = configArray[0].reloadMethodName();
                }
                this.setValue();
            }
            return this.object;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setValue() throws Exception {
        boolean needReload = Boolean.FALSE;
        for (Field field : this.clazz.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            boolean isAccessible = field.isAccessible();
            try {
                Object fieldValue;
                field.setAccessible(true);
                ConvertInfo convertInfo = this.convertInfo;
                ConfigFiled configFiled = field.getAnnotation(ConfigFiled.class);
                if (Objects.isNull(configFiled)) continue;
                String key = this.buildKey(configFiled);
                needReload = this.checkNeedReload(needReload, configFiled);
                ConvertValue<?> convertValue = ConverterMap.getFieldConverter(field);
                if (!this.checkFieldValueBefore(configFiled, key, convertValue, fieldValue = convertValue.processFieldValue(convertInfo, key, configFiled))) continue;
                convertInfo.setValue(fieldValue);
                convertInfo.setField(field);
                convertInfo.setKey(key);
                Object convertedValue = convertValue.convert(convertInfo);
                if (!this.checkFieldValueAfter(configFiled, key, convertedValue)) continue;
                field.set(this.object, convertedValue);
            }
            finally {
                field.setAccessible(isAccessible);
            }
        }
        this.reloadConfigIfNeed(needReload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadConfigIfNeed(boolean needReload) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (needReload) {
            Method method = this.clazz.getDeclaredMethod(this.reloadMethodName == null ? "reload" : this.reloadMethodName, new Class[0]);
            boolean isAccessible = method.isAccessible();
            try {
                method.setAccessible(true);
                method.invoke(this.object, new Object[0]);
            }
            finally {
                method.setAccessible(isAccessible);
            }
        }
    }

    private boolean checkFieldValueAfter(ConfigFiled configFiled, String key, Object convertedValue) {
        if (Objects.isNull(convertedValue)) {
            if (configFiled.notNull()) {
                throw new RuntimeException(key + " can not be null!");
            }
            return false;
        }
        if (configFiled.beNumber() && !StringUtils.isNumeric((CharSequence)String.valueOf(convertedValue))) {
            throw new RuntimeException(key + " must be number!");
        }
        return true;
    }

    private boolean checkFieldValueBefore(ConfigFiled configFiled, String key, ConvertValue<?> convertValue, Object fieldValue) {
        if (Objects.isNull(fieldValue) && !convertValue.canHandleNullValue()) {
            if (configFiled.notNull()) {
                throw new RuntimeException(key + " can not be null!");
            }
            return false;
        }
        return true;
    }

    private boolean checkNeedReload(boolean needReload, ConfigFiled configFiled) {
        if (!needReload && configFiled != null && configFiled.reload()) {
            needReload = Boolean.TRUE;
        }
        if (needReload) {
            try {
                this.clazz.getDeclaredMethod(this.reloadMethodName == null ? "reload" : this.reloadMethodName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("The field needs to be reloaded, but the reload method cannot be found.", e);
            }
        }
        return needReload;
    }

    private String buildKey(ConfigFiled configFiled) {
        StringBuilder keyPrefix = new StringBuilder(Objects.isNull(this.prefix) ? "" : this.prefix);
        String key = configFiled == null || configFiled.field().isEmpty() && keyPrefix.length() > 0 ? keyPrefix.deleteCharAt(keyPrefix.length() - 1).toString() : keyPrefix.append(configFiled.field()).toString();
        return key;
    }
}

