/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.tables.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.KeyValueTableFactory;
import io.pravega.client.admin.KeyValueTableInfo;
import io.pravega.client.connection.impl.ConnectionPool;
import io.pravega.client.control.impl.Controller;
import io.pravega.client.security.auth.DelegationTokenProvider;
import io.pravega.client.security.auth.DelegationTokenProviderFactory;
import io.pravega.client.tables.KeyValueTable;
import io.pravega.client.tables.KeyValueTableClientConfiguration;
import io.pravega.client.tables.impl.KeyValueTableImpl;
import io.pravega.client.tables.impl.TableSegmentFactoryImpl;
import io.pravega.shared.security.auth.AccessOperation;
import java.beans.ConstructorProperties;
import lombok.Generated;
import lombok.NonNull;

public class KeyValueTableFactoryImpl
implements KeyValueTableFactory {
    @NonNull
    private final String scope;
    @NonNull
    private final Controller controller;
    @NonNull
    private final ConnectionPool connectionPool;

    @Override
    public KeyValueTable forKeyValueTable(@NonNull String keyValueTableName, @NonNull KeyValueTableClientConfiguration clientConfiguration) {
        if (keyValueTableName == null) {
            throw new NullPointerException("keyValueTableName is marked non-null but is null");
        }
        if (clientConfiguration == null) {
            throw new NullPointerException("clientConfiguration is marked non-null but is null");
        }
        KeyValueTableInfo kvt = new KeyValueTableInfo(this.scope, keyValueTableName);
        DelegationTokenProvider provider = DelegationTokenProviderFactory.create(this.controller, kvt.getScope(), kvt.getKeyValueTableName(), AccessOperation.READ_WRITE);
        TableSegmentFactoryImpl tsf = new TableSegmentFactoryImpl(this.controller, this.connectionPool, clientConfiguration, provider);
        return new KeyValueTableImpl(kvt, tsf, this.controller, this.connectionPool.getInternalExecutor());
    }

    @Override
    public void close() {
        this.controller.close();
        this.connectionPool.close();
    }

    @ConstructorProperties(value={"scope", "controller", "connectionPool"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public KeyValueTableFactoryImpl(@NonNull String scope, @NonNull Controller controller, @NonNull ConnectionPool connectionPool) {
        if (scope == null) {
            throw new NullPointerException("scope is marked non-null but is null");
        }
        if (controller == null) {
            throw new NullPointerException("controller is marked non-null but is null");
        }
        if (connectionPool == null) {
            throw new NullPointerException("connectionPool is marked non-null but is null");
        }
        this.scope = scope;
        this.controller = controller;
        this.connectionPool = connectionPool;
    }
}

