/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.stream.impl;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.segment.impl.EventSegmentReader;
import io.pravega.common.MathHelpers;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Orderer {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Orderer.class);
    private final AtomicInteger counter = new AtomicInteger(0);

    @VisibleForTesting
    Orderer(int initialCount) {
        this();
        this.counter.set(initialCount);
    }

    @VisibleForTesting
    public <T extends EventSegmentReader> T nextSegment(List<T> segments) {
        if (segments.isEmpty()) {
            return null;
        }
        for (int i = 0; i < segments.size(); ++i) {
            EventSegmentReader inputStream = (EventSegmentReader)segments.get(MathHelpers.abs((int)this.counter.incrementAndGet()) % segments.size());
            if (inputStream.isSegmentReady()) {
                log.trace("Selecting segment: {}", (Object)inputStream.getSegmentId());
                return (T)inputStream;
            }
            inputStream.fillBuffer();
        }
        return null;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Orderer() {
    }
}

